/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.http.HttpClientWrapper;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import com.urbancode.commons.httpcomponentsutil.HttpClientPackage;
import com.urbancode.commons.util.IO;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    static void configureLogging() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        AppenderComponentBuilder consoleAppenderBuilder = ((AppenderComponentBuilder)builder.newAppender("STDOUT", "Console").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT)).add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%m%n"));
        builder.add(consoleAppenderBuilder);
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.WARN).add(builder.newAppenderRef("STDOUT")));
        builder.add(builder.newLogger("httpclient.wire.content", Level.OFF));
        builder.add(builder.newLogger("com.ibm.uclab.csrepl.client.ops", Level.INFO));
        Configurator.reconfigure((Configuration)((Configuration)builder.build()));
    }

    static CodestationClient getCodestationClient(String mainServerUrl, boolean forceUseMainServer, String user, String password) {
        String proxyHost = Util.getenv("PROXY_HOST");
        int proxyPort = Util.parseInt(Util.getenv("PROXY_PORT"));
        String codestationUrl = Util.getenv("CODESTATION_URL");
        boolean codestationUseProxy = Util.parseBoolean(Util.getenv("CODESTATION_USE_PROXY"));
        boolean verifyCerts = Util.parseBoolean(Util.getenv("UC_TLS_VERIFY_CERTS"));
        boolean useMainServer = forceUseMainServer || codestationUrl == null || codestationUseProxy;
        String url = codestationUrl;
        if (useMainServer) {
            url = mainServerUrl;
        }
        url = Util.parseServerUrl(url);
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        if (proxyHost != null && useMainServer) {
            builder.setProxyHost(proxyHost);
            builder.setProxyPort(proxyPort);
        }
        builder.setUsername(user);
        builder.setPassword(password);
        builder.setTrustAllCerts(!verifyCerts);
        builder.setPreemptiveAuthentication(true);
        HttpClientPackage httpClient = builder.buildClientPackage();
        HttpClientWrapper wrapper = new HttpClientWrapper(httpClient);
        wrapper.setTimeout(60000, 300000);
        CodestationClient csc = new CodestationClient(url, wrapper);
        csc.start();
        return csc;
    }

    static List<String> parseCsv(String csv) {
        if (csv == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(csv.split(",")));
    }

    static Charset getCharset(Properties pluginProps) throws IOException {
        String charset = pluginProps.getProperty("charset");
        if (StringUtils.isNotBlank((CharSequence)charset)) {
            return Charset.forName(charset.trim());
        }
        return Util.getSystemCharset();
    }

    static Charset getSystemCharset() throws IOException {
        File agentHome = new File(Util.getenv("AGENT_HOME"));
        Properties agentProps = Util.loadProperties(new File(agentHome, "conf/agent/installed.properties"));
        String encoding = agentProps.getProperty("system.default.encoding");
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            return Charset.forName(encoding.trim());
        }
        return null;
    }

    static String getenv(String key) {
        String value = System.getenv(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return value.trim();
    }

    static UUID parseUUID(String id) {
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> parseLines(String s) {
        List<String> list;
        if (s == null) {
            return Collections.emptyList();
        }
        BufferedReader in = IO.buffer(IO.reader(s));
        try {
            String line;
            ArrayList<String> list2 = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                list2.add(line);
            }
            list = Collections.unmodifiableList(list2);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException impossible) {
                throw new RuntimeException(impossible);
            }
        }
        in.close();
        return list;
    }

    static boolean parseBoolean(String v) {
        return v != null && Boolean.parseBoolean(v.trim());
    }

    static String parseServerUrl(String v) {
        while (v.endsWith("/")) {
            v = v.substring(0, v.length() - 1);
        }
        return v;
    }

    static int parseInt(String v) {
        if (v == null) {
            return 0;
        }
        return Integer.parseInt(v.trim());
    }

    static Properties loadProperties(File file) throws IOException {
        Properties props = new Properties();
        BufferedInputStream in = IO.openInput(file);
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        return props;
    }

    static boolean deleteDir(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        return Util.deleteDir0(file);
    }

    private static boolean deleteDir0(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                Util.deleteDir0(f);
            }
        }
        return file.delete();
    }

    private Util() {
        throw new UnsupportedOperationException();
    }
}

