/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.lifecycle.LifecycleStoppedException;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTableScanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;

class BlobCleanup
implements Runnable {
    private static final Logger log = Logger.getLogger(BlobCleanup.class);
    private final BlobManager bm;
    private final UUID oldBlobId;
    private final UUID newBlobId;

    BlobCleanup(BlobManager bm, UUID oldBlobId, UUID newBlobId) {
        this.bm = bm;
        this.oldBlobId = oldBlobId;
        this.newBlobId = newBlobId;
    }

    @Override
    public void run() {
        try {
            if (this.oldBlobId == null && this.newBlobId == null) {
                return;
            }
            if (this.newBlobId != null && this.newBlobId.equals(this.oldBlobId)) {
                return;
            }
            Set<UUID> newTableIds = null;
            if (this.newBlobId != null) {
                newTableIds = this.getUUIDs(this.newBlobId, this.bm.replicateAndOpenBlob(this.newBlobId));
            }
            Set<UUID> oldTableIds = null;
            if (this.oldBlobId != null) {
                oldTableIds = this.getUUIDs(this.oldBlobId, this.bm.openBlobLocal(this.oldBlobId));
            }
            if (oldTableIds != null) {
                if (newTableIds != null) {
                    oldTableIds.removeAll(newTableIds);
                }
                for (UUID id : oldTableIds) {
                    this.bm.removeBlobLocal(id);
                }
            }
            if (this.oldBlobId != null) {
                this.bm.removeBlobLocal(this.oldBlobId);
            }
        }
        catch (LifecycleStoppedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopped", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error((Object)("Blob cleanup failed: oldBlobId=" + this.oldBlobId + ", newBlobId=" + this.newBlobId), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<UUID> getUUIDs(UUID blobId, InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        try {
            AggregateItem i;
            HashSet<UUID> ids = new HashSet<UUID>();
            ItemTableScanner sc = new ItemTableScanner(in);
            while ((i = sc.read()) != null) {
                UUID id;
                String name = i.getDataFileName();
                if (Aggregate.isSpecialDataFile((String)name) || (id = this.toUUID(name)) == null) continue;
                ids.add(id);
            }
            HashSet<UUID> hashSet = ids;
            return hashSet;
        }
        catch (IOException e) {
            log.error((Object)("Error reading table: blob=" + blobId), (Throwable)e);
            Set<UUID> set = null;
            return set;
        }
        finally {
            in.close();
        }
    }

    private UUID toUUID(String s) {
        if (s == null) {
            return null;
        }
        try {
            s = s.trim();
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Invalid blob ID: " + s), (Throwable)e);
            return null;
        }
    }
}

