/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.plugins.ucd.vfs.Util;
import com.urbancode.plugins.ucd.vfs.ZosDownloadHelper;
import com.urbancode.plugins.ucd.vfs.ZosManifestHelper;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class CompareZosVersionsV2 {
    private static final int ERR_CODE = 1;
    private static final String REPOSITORY_TYPE = "CODESTATION";
    private static final String PDS = "PDS";
    private static final String SEQ = "SEQ";
    private static final String HLINE = "********************************************************************************************************************************************************************************************************";
    private static String userDir = "";

    public static void main(String[] args) {
        try {
            int i;
            File workDir2;
            File workDir1;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties props = apTool.getStepProperties();
            String versionName1 = StringUtils.trimToNull((String)props.getProperty("versionName1"));
            String versionName2 = StringUtils.trimToNull((String)props.getProperty("versionName2"));
            String compName = StringUtils.trimToNull((String)props.getProperty("compName"));
            String resourceId = StringUtils.trimToNull((String)props.getProperty("resourceId"));
            String directoryOffset = ".";
            String serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
            Charset charset = Util.getCharset(props);
            if (CompareZosVersionsV2.emptyString(versionName1)) {
                System.out.println(" [ERROR] Version Name-1 cannot be empty");
                System.exit(1);
            }
            if (CompareZosVersionsV2.emptyString(versionName2)) {
                System.out.println(" [ERROR] Version Name-2 cannot be empty");
                System.exit(1);
            }
            if (versionName1.equals(versionName2)) {
                System.out.println(" [ERROR] Version names cannot be same");
                System.exit(1);
            }
            if (CompareZosVersionsV2.emptyString(compName)) {
                System.out.println(" [ERROR] Component Name cannot be empty");
                System.exit(1);
            }
            Util.configureLogging();
            CompareZosVersionsV2.downloadZosVersion(compName, versionName1, resourceId, directoryOffset, serverUrl, charset, apTool);
            CompareZosVersionsV2.downloadZosVersion(compName, versionName2, resourceId, directoryOffset, serverUrl, charset, apTool);
            String resourcePath = "." + File.separator + resourceId;
            File baseDirectory1 = workDir1 = new File(resourcePath + File.separator + versionName1).getCanonicalFile();
            if (directoryOffset != null) {
                baseDirectory1 = new File(workDir1, directoryOffset).getCanonicalFile();
            }
            File baseDirectory2 = workDir2 = new File(resourcePath + File.separator + versionName2).getCanonicalFile();
            if (directoryOffset != null) {
                baseDirectory2 = new File(workDir2, directoryOffset).getCanonicalFile();
            }
            System.out.println("\n********************************************************************************************************************************************************************************************************");
            ZosManifestHelper zosManifestHelper1 = new ZosManifestHelper();
            System.out.println("\n...Preprocessing for version " + versionName1 + " :\n");
            zosManifestHelper1.createManifestDataStructure(baseDirectory1.getCanonicalPath());
            HashSet<String> pdsSet1 = zosManifestHelper1.getPdsSet();
            HashSet<String> pdsDeletedSet1 = zosManifestHelper1.getPdsDeletedSet();
            HashSet<String> seqSet1 = zosManifestHelper1.getSeqSet();
            HashSet<String> seqDeletedSet1 = zosManifestHelper1.getSeqDeletedSet();
            ZosManifestHelper zosManifestHelper2 = new ZosManifestHelper();
            System.out.println("\n...Preprocessing for version " + versionName2 + " :\n");
            zosManifestHelper2.createManifestDataStructure(baseDirectory2.getCanonicalPath());
            HashSet<String> pdsSet2 = zosManifestHelper2.getPdsSet();
            HashSet<String> seqSet2 = zosManifestHelper2.getSeqSet();
            System.out.println("\n********************************************************************************************************************************************************************************************************");
            System.out.println("\n...Identifying common datasets for comparison :\n");
            ArrayList<String> allSeq = new ArrayList<String>();
            allSeq.addAll(seqSet1);
            for (String seqDsName : seqSet1) {
                if (seqSet2.contains(seqDsName)) continue;
                System.out.println(" [INFO] Skipping comparison for Sequential Dataset - " + seqDsName + " as it does not exist in version - " + versionName2);
                allSeq.remove(seqDsName);
            }
            Iterator<String> seqDeletedIt1 = seqDeletedSet1.iterator();
            while (seqDeletedIt1.hasNext()) {
                System.out.println(" [INFO] Skipping comparison for Sequential Dataset - " + seqDeletedIt1.next() + " as it is under DELETE action in version - " + versionName1);
            }
            ArrayList<String> allPds = new ArrayList<String>();
            allPds.addAll(pdsSet1);
            for (String pdsDsName : pdsSet1) {
                if (pdsSet2.contains(pdsDsName)) continue;
                System.out.println(" [INFO] Skipping comparison for PDS Dataset - " + pdsDsName + " as it does not exist in version - " + versionName2);
                allPds.remove(pdsDsName);
            }
            for (String pdsDeletedDsName : pdsDeletedSet1) {
                if (allPds.contains(pdsDeletedDsName)) continue;
                System.out.println(" [INFO] Skipping comparison for PDS Dataset - " + pdsDeletedDsName + " as it is under DELETE action in version - " + versionName1);
            }
            if (allPds.size() == 0 && allSeq.size() == 0) {
                System.out.println("\n [WARN] No containers found for comparison.\n");
                CompareZosVersionsV2.cleanUpDirectories(baseDirectory1, baseDirectory2);
                System.exit(0);
            }
            userDir = new File(resourcePath).getCanonicalFile().getCanonicalPath();
            System.out.println("\n********************************************************************************************************************************************************************************************************");
            for (i = 0; i < allPds.size(); ++i) {
                System.out.println("\n...Comparing PDS dataset " + (String)allPds.get(i) + "\n");
                CompareZosVersionsV2.diffComparator("." + File.separator + versionName1 + File.separator + (String)allPds.get(i), "." + File.separator + versionName2 + File.separator + (String)allPds.get(i), PDS);
            }
            for (i = 0; i < allSeq.size(); ++i) {
                System.out.println("\n...Comparing Sequential dataset " + (String)allSeq.get(i) + "\n");
                CompareZosVersionsV2.diffComparator("." + File.separator + versionName1 + File.separator + (String)allSeq.get(i), "." + File.separator + versionName2 + File.separator + (String)allSeq.get(i), SEQ);
            }
            CompareZosVersionsV2.cleanUpDirectories(baseDirectory1, baseDirectory2);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void cleanUpDirectories(File baseDir1, File baseDir2) {
        System.out.println("\n********************************************************************************************************************************************************************************************************");
        System.out.println("\n...Directory cleanup : \n");
        if (baseDir1.exists() && baseDir1.isDirectory()) {
            System.out.println("Deleting directory - " + baseDir1);
            Util.deleteDir(baseDir1);
        }
        if (baseDir2.exists() && baseDir2.isDirectory()) {
            System.out.println("Deleting directory - " + baseDir2);
            Util.deleteDir(baseDir2);
        }
        System.out.println("\n********************************************************************************************************************************************************************************************************");
    }

    private static void diffComparator(String dataSetFile1, String dataSetFile2, String datasetType) throws Exception {
        Processes processes = new Processes();
        Process process = null;
        String[] cmdArgs = new String[]{"diff", "-sc", dataSetFile1, dataSetFile2};
        process = new ProcessBuilder(cmdArgs).directory(new File(userDir)).start();
        process.getOutputStream().close();
        Future<String> sout = processes.getOutputStringFuture(process);
        Future<String> serr = processes.getErrorStringFuture(process);
        process.waitFor();
        if (process.exitValue() == 0 && datasetType.equalsIgnoreCase(SEQ)) {
            System.out.println("Files " + dataSetFile1 + " and " + dataSetFile2 + " are identical");
        } else if (process.exitValue() < 2) {
            System.out.println(sout.get());
        } else {
            System.out.println(" [ERROR] Comparison process failed with code - " + process.exitValue());
            System.out.println("Process Output : \n" + sout.get());
            System.out.println("Process Error : \n" + serr.get());
            throw new Exception("Error while running diff between file " + dataSetFile1 + " and " + dataSetFile2);
        }
    }

    public static void downloadZosVersion(String componentName, String versionName, String resourceId, String directoryOffset, String serverUrl, Charset charset, AirPluginTool apTool) throws Exception {
        System.out.println("\n...Downloading version - " + versionName);
        VersionClient ucdVersionClient = new VersionClient(new URI(serverUrl), apTool.getAuthTokenUsername(), apTool.getAuthToken());
        UUID versionId = ucdVersionClient.getVersionId(componentName, versionName);
        ZosDownloadHelper zosDownloadHelper = new ZosDownloadHelper(REPOSITORY_TYPE, versionName, versionId, resourceId, directoryOffset, serverUrl, charset, apTool, false);
        zosDownloadHelper.downloadVersion();
        if (zosDownloadHelper.isSecondVersion()) {
            zosDownloadHelper.extractVersion();
        } else {
            System.out.println(" [ERROR] Version " + versionName + " must be in new package format.");
            System.exit(1);
        }
    }

    private static boolean emptyString(String str) {
        if (null == str) {
            return true;
        }
        return str.trim().length() == 0;
    }
}

