/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Upload;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class UploadCommand {
    public static void main(String[] args) throws Exception {
        AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
        Properties props = apTool.getStepProperties();
        File baseDirectory = new File(props.getProperty("directoryOffset"));
        String fileIncludePatterns = props.getProperty("fileIncludePatterns");
        String fileExcludePatterns = props.getProperty("fileExcludePatterns");
        List<String> extensions = Util.parseCsv(props.getProperty("extensions"));
        boolean saveFileExecuteBits = Util.parseBoolean(props.getProperty("saveFileExecuteBits"));
        UUID versionId = UUID.fromString(props.getProperty("versionId"));
        String serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
        List<String> includes = Util.parseLines(fileIncludePatterns);
        List<String> excludes = Util.parseLines(fileExcludePatterns);
        Charset systemCharset = Util.getSystemCharset();
        if (baseDirectory.isFile()) {
            throw new IllegalArgumentException("Base directory " + baseDirectory + " is a file");
        }
        Util.configureLogging();
        CodestationClient csClient = Util.getCodestationClient(serverUrl, true, apTool.getAuthTokenUsername(), apTool.getAuthToken());
        Upload op = new Upload(csClient, baseDirectory, versionId);
        op.setIncludes(includes);
        op.setExcludes(excludes);
        op.setTextFileCharset(systemCharset);
        op.setTextFileExtensions(extensions);
        op.setSaveExecuteBits(saveFileExecuteBits);
        op.run();
    }
}

