/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore.pruner;

import com.ibm.uclab.csrepl.blobstore.BlobMetadata;
import java.util.Collections;
import java.util.List;

class Limiter {
    private List<BlobMetadata> list;
    private long maxSize;
    private int splitIndex;

    Limiter(List<BlobMetadata> list, long maxSize) {
        this.list = list;
        this.maxSize = maxSize;
        this.splitIndex = -1;
    }

    public List<BlobMetadata> getToKeep() {
        this.split();
        return this.list.subList(0, this.splitIndex);
    }

    public List<BlobMetadata> getToRemove() {
        this.split();
        return this.list.subList(this.splitIndex, this.list.size());
    }

    private void split() {
        if (this.splitIndex != -1) {
            return;
        }
        Collections.sort(this.list, Collections.reverseOrder(BlobMetadata.byLastAccess()));
        int i = 0;
        long runningSize = 0L;
        for (BlobMetadata lm : this.list) {
            if ((runningSize += lm.getLength()) > this.maxSize) {
                this.splitIndex = i;
                return;
            }
            ++i;
        }
        this.splitIndex = i;
    }
}

