/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.DownloadBase;
import com.ibm.uclab.csrepl.client.ops.VerifyResult;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Verify
extends DownloadBase {
    private static final Logger log = Logger.getLogger(Verify.class);
    protected int failureCount;

    public Verify(CodestationClient client, File destination, UUID artifactSetId) {
        super(client, destination, Collections.singletonList(artifactSetId));
    }

    @Override
    public void run() throws IOException {
        this.downloadMetadata();
        this.verify();
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    private void verify() throws IOException {
        log.info((Object)("Verifying files in " + this.destination.getAbsolutePath()));
        for (FileMetadata m : this.meta) {
            File f = this.toFile(m);
            VerifyResult r = this.verify(f, m);
            if (r.isOK()) {
                log.info((Object)("Success: " + r.getPath()));
                continue;
            }
            ++this.failureCount;
            log.info((Object)("Fail: " + r.getMessage() + ": " + r.getPath()));
            if (r.getDetail() == null) continue;
            log.info((Object)("      " + r.getDetail()));
        }
    }
}

