/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.download;

import com.ibm.urbancode.zos.checksum.ChecksumVerifier;
import com.ibm.urbancode.zos.checksum.InvalidChecksumException;
import com.ibm.urbancode.zos.helpers.FileHelper;
import com.ibm.urbancode.zos.helpers.ManifestVersion;
import com.ibm.urbancode.zos.helpers.PaxExtractor;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.Util;
import com.urbancode.plugins.ucd.vfs.zos.download.DownloadZosVersionInputs;
import com.urbancode.plugins.ucd.vfs.zos.helpers.InvalidInputException;
import com.urbancode.plugins.ucd.vfs.zos.helpers.VersionDownloader;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;

public class DownloadZosVersionCommand {
    private static final int ERR_CODE = 1;
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private final DownloadZosVersionInputs pluginInputs;
    private final AirPluginTool apTool;

    public DownloadZosVersionCommand(DownloadZosVersionInputs pluginInputs, AirPluginTool apTool) {
        this.pluginInputs = pluginInputs;
        this.apTool = apTool;
    }

    public static void main(String[] args) {
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties props = apTool.getStepProperties();
            DownloadZosVersionInputs pluginInputs = DownloadZosVersionInputs.getValidatedInputs(props);
            DownloadZosVersionCommand downloadZosVersionCommand = new DownloadZosVersionCommand(pluginInputs, apTool);
            downloadZosVersionCommand.run();
            System.exit(0);
        }
        catch (InvalidChecksumException | InvalidInputException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private void run() throws Exception {
        this.setupNewBaseDir();
        this.downloadVersionArtifacts();
        this.verifyChecksum();
        String manifestPath = this.pluginInputs.getBaseDir() + File.separator + PACKAGE_MANIFEST_XML;
        if (ManifestVersion.isV2((String)manifestPath)) {
            this.extractPackageZip();
            this.renamePackageZip();
        }
    }

    private void setupNewBaseDir() throws IOException {
        if (FileHelper.isDirectoryExist((String)this.pluginInputs.getBaseDir())) {
            System.out.println("Deleting directory : " + this.pluginInputs.getBaseDir());
            Util.deleteDir(new File(this.pluginInputs.getBaseDir()));
        }
        FileHelper.createDir((String)this.pluginInputs.getBaseDir());
    }

    private void downloadVersionArtifacts() throws Exception {
        VersionDownloader versionDownloader = new VersionDownloader(this.pluginInputs.getServerUrl(), this.apTool);
        versionDownloader.download(this.pluginInputs.getVersionId(), this.pluginInputs.getBaseDir());
    }

    private void verifyChecksum() throws GeneralSecurityException, IOException, InvalidChecksumException {
        String checksumPropertiesFilePath = this.pluginInputs.getBaseDir() + File.separator + "versionChecksum.properties";
        if (FileHelper.isFileExist((String)checksumPropertiesFilePath)) {
            ChecksumVerifier.verify((String)this.pluginInputs.getBaseDir());
        }
    }

    private void extractPackageZip() throws Exception {
        String zipFilePath = this.pluginInputs.getBaseDir() + File.separator + "package.zip";
        if (FileHelper.isFileExist((String)zipFilePath)) {
            PaxExtractor.extract((String)zipFilePath, (String)this.pluginInputs.getBaseDir());
        }
    }

    private void renamePackageZip() throws IOException {
        String zipFilePath = this.pluginInputs.getBaseDir() + File.separator + "package.zip";
        if (FileHelper.isFileExist((String)zipFilePath)) {
            String processedZipFilePath = this.pluginInputs.getBaseDir() + File.separator + "processed_package.zip";
            System.out.println("Renaming file " + zipFilePath + " to " + processedZipFilePath);
            FileHelper.renameFile((String)zipFilePath, (String)processedZipFilePath);
        }
    }
}

