/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.download;

import com.urbancode.plugins.ucd.vfs.Util;
import com.urbancode.plugins.ucd.vfs.zos.helpers.InvalidInputException;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class DownloadZosVersionInputs {
    public static final String REPOSITORY_TYPE = "repositoryType";
    public static final String VERSION_NAME = "versionName";
    public static final String VERSION_ID = "versionId";
    public static final String RESOURCE_ID = "resourceId";
    public static final String DIRECTORY_OFFSET = "directoryOffset";
    public static final String SERVER_URL = "serverUrl";
    private static final String CODESTATION = "CODESTATION";
    private static final String WORK_DIR = System.getProperty("user.dir");
    private final String repositoryType;
    private final String versionName;
    private final String versionId;
    private final String resourceId;
    private final String directoryOffset;
    private final String serverUrl;

    private DownloadZosVersionInputs(Properties inputProperties) {
        this.repositoryType = inputProperties.getProperty(REPOSITORY_TYPE).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.versionId = inputProperties.getProperty(VERSION_ID).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.directoryOffset = inputProperties.getProperty(DIRECTORY_OFFSET).trim();
        this.serverUrl = Util.parseServerUrl(inputProperties.getProperty(SERVER_URL).trim());
    }

    public static DownloadZosVersionInputs getValidatedInputs(Properties inputProperties) {
        DownloadZosVersionInputs inputs = new DownloadZosVersionInputs(inputProperties);
        inputs.validate();
        return inputs;
    }

    private void validate() {
        if (this.repositoryType.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Repository Type is empty.");
        }
        if (this.versionName.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Version Name is empty.");
        }
        if (this.versionId.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Version Id is empty.");
        }
        if (this.resourceId.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Resource Id is empty.");
        }
        if (!this.repositoryType.equalsIgnoreCase(CODESTATION)) {
            throw new InvalidInputException(" [ERROR] Version is stored in " + this.repositoryType);
        }
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getDirectoryOffset() {
        return this.directoryOffset;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getBaseDir() throws IOException {
        String versionDir = WORK_DIR + File.separator + this.resourceId + File.separator + this.versionName;
        if (this.directoryOffset.isEmpty()) {
            return versionDir;
        }
        return new File(versionDir, this.directoryOffset).getCanonicalPath();
    }
}

