import com.urbancode.air.plugin.wldeploy.WebLogicStatusHelper;

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

Properties outProps = new Properties();

final def jmxUrl = props['jmxUrl'];
def user = props['user'];
def pass = props['password'];
final def configFile = props['configFile'];
final def keyFile = props['keyFile'];
def targets = props['targets'];

targets = targets.split(',');

try {
    WebLogicStatusHelper helper = new WebLogicStatusHelper();
    if (configFile) {
        user = helper.getUser(configFile, keyFile);
        pass = helper.getPass(configFile, keyFile);
    }
    helper.initConn(jmxUrl, user, pass);
    targets.each { target ->
       println "getting apps for $target";
       String appList = helper.getAppsForTarget(target);
       outProps.setProperty("apps-$target", appList);
    }

    helper.closeConn();

}
catch (Exception e) {
    e.printStackTrace();
    throw e;
}

final OutputStream outputPropsStream = null;
try {
    outputPropsStream = new FileOutputStream(new File(args[1]));
    outProps.store(outputPropsStream, "");
}   
finally {
    if (outputPropsStream != null) {
        outputPropsStream.close();
    }   
} 
