import com.urbancode.air.plugin.wldeploy.WebLogicStatusHelper;


final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}
final def jmxUrl = props['jmxUrl'];
def user = props['user'];
def pass = props['password'];
final def configFile = props['configFile'];
final def keyFile = props['keyFile'];
def targets = props['targets'];
def app = props['app'];
def wantedStatus = props['wantedStatus']
def badStatuses = [];
badStatuses <<"start";

targets = targets.split(',');

try {
    WebLogicStatusHelper helper = new WebLogicStatusHelper();
    if (configFile) {
        user = helper.getUser(configFile, keyFile);
        pass = helper.getPass(configFile, keyFile);
    }
    helper.initConn(jmxUrl, user, pass);
    while (!badStatuses.isEmpty()) {
        badStatuses.clear();
        targets.each { target ->
            System.out.println("Checking Target ${target}");
            def status = helper.getAppState(app,target);
            if (status != wantedStatus) {
                badStatuses << [target, status];
            }
        }
        println "App not in correct state on some targets: ";
        println badStatuses;
        Thread.sleep(10000);
    }
    helper.closeConn();

    System.exit(0);
}
catch (Exception e) {
    e.printStackTrace();
    throw e;
}
