import com.urbancode.air.plugin.wldeploy.WebLogicStatusHelper;


final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}
final def jmxUrl = props['jmxUrl'];
def user = props['user'];
def pass = props['password'];
final def configFile = props['configFile'];
final def keyFile = props['keyFile'];
def targets = props['targets'];
def app = props['app'];
def wantedStatus = props['wantedStatus']
def badStatuses = [];

targets = targets.split(',');

try {
    WebLogicStatusHelper helper = new WebLogicStatusHelper();
    if (configFile) {
        user = helper.getUser(configFile, keyFile);
        pass = helper.getPass(configFile, keyFile);
    }
    helper.initConn(jmxUrl, user, pass);
    targets.each { target ->
        System.out.println("Checking Target ${target}");
        def status = helper.getAppState(app,target);
        if (status != wantedStatus) {
            badStatuses << [target, status];
        }
    }
    helper.closeConn();

    if (!badStatuses.isEmpty()) {
        badStatuses.each { status ->
            System.out.println("Application " + app + " on " + status[0] + " is not in correct state : " + status[1])
        }
        System.exit(1);
    }
    System.exit(0);
}
catch (Exception e) {
    e.printStackTrace();
    throw e;
}
