/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
AirPluginTool apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties(System.getenv("UCD_SECRET_VAR"), System.getenv("UCD_SUITE_VAR"))
final def isWindows = apTool.isWindows

final def url = props['url']
final def user = props['user']
final def pass = props['password']
final def configfile = props['configFile']
final def keyfile = props['keyFile']
def targets = props['targets']
final def path = props['path']
final def appName = props['appName'].trim()
final def source = props['source']
final def operation = props['operation']
final def retiretimeout = props['retiretimout']
final def plan = props['plan']
final def planver = props['planver']
final def altappdd = props['altappdd']
final def altwlsappdd = props['altwlsappdd']
final def appver = props['appver']
final def id = props['id']
final def remote = props['remote']
def additionalProps = props['additionalProps']
if (additionalProps != null && additionalProps != "") {
    additionalProps = additionalProps.split('\n')
}
def sysProps = props['sysProps']
if (sysProps) {
    sysProps = sysProps.split('\n')
}

final def ch = new CommandHelper(workDir)
def cmdLineArgs = []

def javahome = System.getenv("JAVA_HOME")

if(props['javahome']) {
    javahome = props['javahome']
}
def javaExe = javahome + File.separator + "bin" + File.separator + "java"

if (isWindows) {
    javaExe += ".exe"
}

cmdLineArgs << javaExe
cmdLineArgs << "-cp"

if (isWindows) {
    cmdLineArgs << '"' + path + '"'
}
else {
    cmdLineArgs << path
}

// append user defined java system properties
sysProps.each {sysProp ->
    sysProp = sysProp.trim()
    if (sysProp) {
        cmdLineArgs << "-D" + sysProp
    }
}

cmdLineArgs << "weblogic.Deployer"
cmdLineArgs << "-verbose"
cmdLineArgs << "-debug"
cmdLineArgs << "-${operation}"
cmdLineArgs << "-name"
cmdLineArgs <<  appName
cmdLineArgs << "-targets"
cmdLineArgs << targets
cmdLineArgs << "-adminurl"
cmdLineArgs << url

if (user) {
    cmdLineArgs << "-user"
    cmdLineArgs << user
    cmdLineArgs << "-password"
    cmdLineArgs << pass
}
else {
    cmdLineArgs << "-userconfigfile"
    cmdLineArgs << configfile
    cmdLineArgs << "-userkeyfile"
    cmdLineArgs << keyfile
}
if (operation.matches("redeploy|deploy|distribute")) {
    if (source != null && source != "") {
        cmdLineArgs << "-source"
        cmdLineArgs << source
    }
}
if (retiretimeout != null && retiretimout != "") {
    cmdLineArgs << "-retiretimeout"
    cmdLineArgs << retiretimeout
}
if (plan != null && plan != "") {
    cmdLineArgs << "-plan"
    cmdLineArgs << plan
}
if (planver != null && planver != "") {
    cmdLineArgs << "-planversion"
    cmdLineArgs << planver
}
if (appver != null && appver != "") {
    cmdLineArgs << "-appversion"
    cmdLineArgs << appver
}
if (altappdd != null && altappdd != "") {
    cmdLineArgs << "-altappdd"
    cmdLineArgs << altappdd
}
if (altwlsappdd != null && altwlsappdd != "") {
    cmdLineArgs << "-altwlsappdd"
    cmdLineArgs << altwlsappdd
}
if (id != null && id != "") {
    cmdLineArgs << "-id"
    cmdLineArgs << id
}
if (remote != null && remote != "" && !remote.equals("false")) {
    cmdLineArgs << "-remote"
}
additionalProps.each { additionalProp ->
    def splitUp = additionalProp.split('=', 2)
    if (splitUp.length == 2) {
        cmdLineArgs << "-${splitUp[0]} ${splitUp[1]}"
    }
    else if (splitUp.length == 1) {
        cmdLineArgs << "-${splitUp[0]}"
    }
}

ch.runCommand(cmdLineArgs.join(' '), cmdLineArgs)