#!/usr/bin/env groovy

/*
- Licensed Materials - Property of IBM Corp.
- IBM UrbanCode Deploy
- (c) Copyright IBM Corporation 2014, 2016. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
*/
import java.io.FileNotFoundException
import java.io.IOException
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def workDir = new File('.').canonicalFile;

final def wsrrhome = props['wsrrhome'];
final def user = props['user'];
final def password = props['password'];
final def cluster = props['cluster'];
final def cell = props['cell'];
final def node = props['node'];
final def server = props['server'];
final def profilename = props['profilename'];


def pluginHome = new File(System.getenv("PLUGIN_HOME"))
println "Setup of path using plugin home: " + pluginHome;
def jaclScriptsDir = new File(pluginHome, "/jacl-scripts")
def commandHelper = new CommandHelper(jaclScriptsDir);

def jaclScript = "activateConfigurationProfile.jacl"

// Setup path
try {
	def curPath = System.getenv("PATH");
	println "Current PATH: " + curPath

	println "Setup of path using wsrr home: " + wsrrhome;
	def binDir = new File(wsrrhome, "/../bin")
	def newPath = curPath+":"+binDir.absolutePath;
	commandHelper.addEnvironmentVariable("PATH", newPath);

	commandHelper.printEnvironmentVariables();

} catch(Exception e){
	println "ERROR setting path: ${e.message}"
	System.exit(1)
}


// Push the application
try {
	def commandArgs = ["wsadmin.sh", "-f", jaclScript];

	if (wsrrhome) {
		commandArgs << "-wsrrhome";
		commandArgs << wsrrhome;
	}

	if (user) {
		commandArgs << "-user";
		commandArgs << user;
	}

	if (password) {
		commandArgs << "-password";
		commandArgs << password;
	}

	if (cluster) {
		commandArgs << "-cluster";
		commandArgs << cluster;
	}

	if (cell) {
		commandArgs << "-cell" ;
		commandArgs << cell;
	}

	if (node) {
		commandArgs << "-node" ;
		commandArgs << node;
	}

	if (server) {
		commandArgs << "-server" ;
		commandArgs << server;
	}

	if (profilename) {
		commandArgs << "-profilename" ;
		commandArgs << profilename;
	}

	commandHelper.runCommand("Activating WSRR Configuration Profile", commandArgs);
} catch(Exception e){
	println "ERROR Activating : ${e.message}";
	System.exit(1);
}
