/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.deploy.wsrr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WSDLLoader {
    private File csvFile = null;
    private File wsdlPath = null;
    private String hostname;
    private String port;
    DocumentBuilderFactory docBuilderFactory = null;
    DocumentBuilder docBuilder = null;
    private XPathExpression valueAttrExpression = null;
    private static final String XPATH_EXPR_VALUE_ATTR = "//property/@value";
    private static final String ELEMENT_RESOURCES = "resources";
    private static final String ELEMENT_RESOURCE = "resource";
    private static final String ELEMENT_PROPERTIES = "properties";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_RELATIONSHIPS = "relationships";
    private static final String ELEMENT_RELATIONSHIP = "relationship";
    private static final String ELEMENT_CLASSIFICATIONS = "classifications";
    private static final String ELEMENT_CLASSIFICATION = "classification";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TARGET_BSRURI = "targetBsrURI";
    private static final String ATTR_URI = "uri";
    private static final String PropertyConstants_NAME = "name";
    private static final String PropertyConstants_NAMESPACE = "namespace";
    private static final String PropertyConstants_DESCRIPTION = "description";
    private static final String PropertyConstants_VERSION = "version";
    private static final String PropertyConstants_PRIMARY_TYPE = "primary_type";
    private static final String PROPERTY_ALE63_ASSET_WEB_LINK = "ale63_assetWebLink";
    private static final String PROPERTY_ALE63_FULL_DESCRIPTION = "ale63_fullDescription";
    private static final String PROPERTY_ALE63_REMOTE_STATE = "ale63_remoteState";
    private static final String PROPERTY_ALE63_ASSET_TYPE = "ale63_assetType";
    private static final String PROPERTY_ALE63_REQUIREMENTS_LINK = "ale63_requirementsLink";
    private static final String PROPERTY_ALE63_OWNER_EMAIL = "ale63_ownerEmail";
    private static final String PROPERTY_ALE63_GUID = "ale63_guid";
    private static final String PROPERTY_ALE63_COMMUNITY_NAME = "ale63_communityName";
    private static final String PROPERTY_ALE63_ASSET_OWNERS = "ale63_assetOwners";
    private static final String PROPERTY_GEP63_CONSUMER_IDENTIFIER = "gep63_consumerIdentifier";
    private static final String PROPERTY_GEP63_VERSION_AVAILABILITY_DATE = "gep63_versionAvailabilityDate";
    private static final String PROPERTY_GEP63_VERSION_TERMINATION_DATE = "gep63_versionTerminationDate";
    private static final String PROPERTY_GEP63_CONSUMER_IDENTIFIER_LOCATION = "gep63_consumerIdentifierLocationInfo";
    private static final String PROPERTY_GEP63_CONTEXT_IDENTIFIER_LOCATION = "gep63_contextIdentifierLocationInfo";
    private static final String RELATIONSHIP_ALE63_DEPENDENCY = "ale63_dependency";
    private static final String RELATIONSHIP_ALE63_ARTIFACTS = "ale63_artifacts";
    private static final String RELATIONSHIP_ALE63_OWNING_ORGANIZATION = "ale63_owningOrganization";
    private static final String RELATIONSHIP_GEP63_SERVICE_INTERFACE_VERSIONS = "gep63_serviceInterfaceVersions";
    private static final String RELATIONSHIP_GEP63_CHARTER = "gep63_charter";
    private static final String RELATIONSHIP_GEP63_CAPABILITY_VERSIONS = "gep63_capabilityVersions";
    private static final String RELATIONSHIP_GEP63_CONSUMES = "gep63_consumes";
    private static final String RELATIONSHIP_GEP63_PROVIDES = "gep63_provides";
    private static final String RELATIONSHIP_GEP63_INTERFACE_SPECIFICATIONS = "gep63_interfaceSpecifications";
    private static final String RELATIONSHIP_GEP63_PROVIDED_WEB_SERVICES = "gep63_providedWebServices";
    private static final String RELATIONSHIP_GEP63_PROVIDED_REST_SERVICES = "gep63_providedRESTServices";
    private static final String RELATIONSHIP_GEP63_PROVIDED_SCA_MODULES = "gep63_providedSCAModules";
    private static final String RELATIONSHIP_GEP63_BOUND_SCA_EXPORT = "gep63_boundScaExport";
    private static final String RELATIONSHIP_GEP63_ANONYMOUS_SLA = "gep63_anonymousSLA";
    private static final String RELATIONSHIP_GEP63_CAMPATIBLE_SLDS = "gep63_compatibleSLDs";
    private static final String RELATIONSHIP_GEP63_BOUND_WEB_SERVICE_PORT = "gep63_boundWebServicePort";
    private static final String RELATIONSHIP_GEP63_BOUND_REST_SERVICE = "gep63_boundRESTService";
    private static final String RELATIONSHIP_GEP63_SERVICE_INTERFACE = "gep63_serviceInterface";
    private static final String RELATIONSHIP_GEP63_AVAILABLE_ENDPOINTS = "gep63_availableEndpoints";
    private static final String RELATIONSHIP_GEP63_AVAILABLE_OPERATIONS = "gep63_availableOperations";
    private static final String OWL_URI_BUSINESS_SERVICE = "http://www.ibm.com/xmlns/prod/serviceregistry/profile/v6r3/GovernanceEnablementModel#BusinessService";
    private static final String OWL_URI_SERVICE_VERSION = "http://www.ibm.com/xmlns/prod/serviceregistry/profile/v6r3/GovernanceEnablementModel#ServiceVersion";
    private static final String OWL_URI_SLD = "http://www.ibm.com/xmlns/prod/serviceregistry/profile/v6r3/GovernanceEnablementModel#ServiceLevelDefinition";
    private static final String SLD_NAME_PREFIX = "SLD - ";
    private static final String SLD_DESCRIPTION = "Service Level Definition for version {0} of the {1}";
    private static final String REQUIREMENTS_DOC_DESCRIPTION = "Requirements document for the {0}";
    private static final String EMPTY_STRING = "";

    static {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, trustAllCerts, new SecureRandom());
            SSLContext.setDefault(sslCtx);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslCtx.getSocketFactory());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public WSDLLoader(File csvFile, File wsdlPath, String hostname, String port, final String username, final String password) throws Exception {
        this.csvFile = csvFile;
        this.wsdlPath = wsdlPath;
        this.hostname = hostname;
        this.port = port;
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        });
        try {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            this.valueAttrExpression = xPath.compile(XPATH_EXPR_VALUE_ATTR);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw e;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        File wsdlPath = new File(".");
        File csvFile = null;
        String hostname = "localhost";
        String port = "9443";
        String username = "wasadmin";
        String password = "password";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-csvFile") && i < args.length - 1) {
                csvFile = new File(args[i + 1]);
            }
            if (args[i].equals("-wsdlPath") && i < args.length - 1) {
                wsdlPath = new File(args[i + 1]);
            }
            if (args[i].equals("-hostname") && i < args.length - 1) {
                hostname = args[i + 1];
            }
            if (args[i].equals("-port") && i < args.length - 1) {
                port = args[i + 1];
            }
            if (args[i].equals("-username") && i < args.length - 1) {
                username = args[i + 1];
            }
            if (args[i].equals("-password") && i < args.length - 1) {
                password = args[i + 1];
            }
            i += 2;
        }
        if (wsdlPath == null || csvFile == null || hostname == null || port == null) {
            System.out.println("WSDLLoader -csvFile <csvfile> [-wsdlPath <wsdlpath> -hostname <hostname> -port <port> -username <username> -password <password>]");
            System.out.println(EMPTY_STRING);
            System.out.println("  -csvFile full file name of the CSV file that will be imported");
            System.out.println(EMPTY_STRING);
            System.out.println("  -wsdlpath full path to a directory containing the WSDL and XSD documents.");
            System.out.println("            Defaults to the current directory.");
            System.out.println(EMPTY_STRING);
            System.out.println("  -hostname hostname or IP address to the Service Registry service.");
            System.out.println("            Defaults to localhost.");
            System.out.println(EMPTY_STRING);
            System.out.println("  -port  Service Registry WC_defaulthost port. (WC_defaulthost port is the same port");
            System.out.println("         that the Service Registry Web UI is hosted on -- typically 9080/9443 in a");
            System.out.println("         standalone secure/unsecure environment). Defaults to 9433.");
            return;
        }
        System.out.println("csvFile: " + csvFile);
        System.out.println("wsdlPath: " + wsdlPath);
        System.out.println("hostname: " + hostname);
        System.out.println("port: " + port);
        System.out.println("username: " + username);
        WSDLLoader loader = new WSDLLoader(csvFile, wsdlPath, hostname, port, username, password);
        loader.loadServices();
        System.out.println("Load complete");
    }

    private ArrayList<HashMap<String, String>> readCSV() throws IOException {
        ArrayList<HashMap<String, String>> services = new ArrayList<HashMap<String, String>>();
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
        String line = reader.readLine();
        if (line != null) {
            String[] headers = line.split(",");
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split(",");
                if (fields.length != headers.length) continue;
                HashMap<String, String> service = new HashMap<String, String>();
                int i = 0;
                int j = 0;
                while (i < headers.length && j < fields.length) {
                    System.out.println(String.valueOf(headers[i]) + " : " + fields[i]);
                    service.put(headers[i], fields[j]);
                    ++i;
                    ++j;
                }
                services.add(service);
            }
        }
        return services;
    }

    private String generateProperty(HashMap<String, String> service, String propertyName, String csvColumn) throws UnsupportedEncodingException {
        String value = service.get(csvColumn);
        if (value == null) {
            return EMPTY_STRING;
        }
        return "&" + propertyName + "=" + URLEncoder.encode(value, "UTF-8");
    }

    public void loadServices() throws Exception {
        System.out.println("Loading WSDL Documents");
        ArrayList<HashMap<String, String>> services = this.readCSV();
        for (HashMap<String, String> service : services) {
            System.out.println("service size is = " + service.size());
            String wsdlFileName = service.get("WSDL Filename");
            System.out.println("WSDL Filename is= " + wsdlFileName);
            File wsdlFile = new File(this.wsdlPath, wsdlFileName);
            String requirementsDocFileName = service.get("Documentation Filename");
            System.out.println("Requirements Filename is = " + requirementsDocFileName);
            File requirementsFile = new File(this.wsdlPath, requirementsDocFileName);
            String params = "name=" + URLEncoder.encode(service.get("Name"), "UTF-8") + this.generateProperty(service, PropertyConstants_DESCRIPTION, "Description") + this.generateProperty(service, PropertyConstants_VERSION, "Version") + this.generateProperty(service, "Status", "Status") + this.generateProperty(service, "DateInProduction", "Date in Production") + this.generateProperty(service, "Owner", "Owner") + this.generateProperty(service, "EndpointURL", "Endpoint URL") + this.generateProperty(service, "DocumentationFilename", "Documentation Filename") + this.generateProperty(service, "WSDLFilename", "WSDL Filename");
            String wsdlDocURL = "https://" + this.hostname + ":" + this.port + "/WSRR/8.0/Content/WSDLDocument?" + params;
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println("queryURL is :" + wsdlDocURL);
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println("wsdlFile is :" + wsdlFile);
            System.out.println("--------------------------------------------------------------------------------");
            String wsdlDocBsrUri = this.loadDocumentTree(wsdlDocURL, wsdlFile);
            Object[] inserts = new Object[]{service.get("Name")};
            String description = MessageFormat.format(REQUIREMENTS_DOC_DESCRIPTION, inserts);
            params = "name=" + URLEncoder.encode(service.get("Documentation Filename"), "UTF-8") + "&description=" + URLEncoder.encode(description, "UTF-8");
            String binaryDocURL = "https://" + this.hostname + ":" + this.port + "/WSRR/8.0/Content/GenericDocument?" + params;
            String requirementDocBsrUri = this.loadDocumentTree(binaryDocURL, requirementsFile);
            String createURL = "https://" + this.hostname + ":" + this.port + "/WSRR/8.0/Content/GenericObject";
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println("createURL is :" + createURL);
            System.out.println("--------------------------------------------------------------------------------");
            String sldBsrUri = this.createServiceLevelDefinition(createURL, service);
            String serviceVersionBsrUri = this.createServiceVersion(createURL, service, wsdlDocBsrUri, sldBsrUri);
            this.createBusinessService(createURL, service, serviceVersionBsrUri, requirementDocBsrUri);
        }
    }

    private String loadDocumentTree(String queryURL, File sourceFile) throws Exception {
        String bsrURI = null;
        boolean retry = true;
        while (retry) {
            try {
                bsrURI = this.loadDocument(queryURL, sourceFile);
                retry = false;
            }
            catch (MustImportReferenceException reference) {
                File referenceFile = new File(this.wsdlPath, reference.getFilename());
                String name = referenceFile.getName();
                String extension = name.substring(name.lastIndexOf(".") + 1);
                String type = null;
                if (extension.equalsIgnoreCase("wsdl")) {
                    type = "WSDLDocument";
                } else if (extension.equalsIgnoreCase("xsd")) {
                    type = "XSDDocument";
                } else {
                    throw new Exception("Unsupported type " + extension + " when loading referenced file " + reference.getFilename());
                }
                String referenceQueryURL = "http://" + this.hostname + ":" + this.port + "/WSRR/7.0/Content/" + type + "?name=" + URLEncoder.encode(name, "UTF-8");
                System.out.println("referenceQueryURL is :" + referenceQueryURL);
                System.out.println("referenceFile is :" + referenceFile);
                this.loadDocumentTree(referenceQueryURL, referenceFile);
            }
        }
        return bsrURI;
    }

    /*
     * Unable to fully structure code
     */
    private String loadDocument(String queryURL, File sourceFile) throws Exception {
        block7: {
            bsrURI = null;
            url = new URL(queryURL);
            System.out.println("url is :" + url);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "UTF-8");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            in = new FileInputStream(sourceFile);
            out = urlConnection.getOutputStream();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            out.flush();
            reader = null;
            try {
                System.out.println("+++++++ ");
                inputStream = urlConnection.getInputStream();
                if (urlConnection.getResponseCode() == 201) {
                    bsrURI = this.processResponse(inputStream);
                    System.out.println("Successfully created " + sourceFile.getName());
                    break block7;
                }
                reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                stringBuffer = new StringBuffer();
                line = null;
                while ((line = reader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                reader.close();
                throw new Exception("Unable to create " + sourceFile.getName() + ": " + stringBuffer.toString());
            }
            catch (IOException ex) {
                System.out.println("------------------------");
                System.out.println("------------------------");
                System.out.println("ex is-----" + ex.toString());
                System.out.println("------------------------");
                System.out.println("------------------------");
                reader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                stringBuffer = new StringBuffer();
                line = null;
                ** while ((line = reader.readLine()) != null)
            }
lbl-1000:
            // 1 sources

            {
                stringBuffer.append(line);
                continue;
            }
lbl46:
            // 1 sources

            reader.close();
            if (urlConnection.getResponseCode() == 500 && (referencedFile = this.getReferencedFilename(stringBuffer.toString())) != null) {
                throw new MustImportReferenceException(referencedFile);
            }
            throw new Exception("Received unexpected resposne " + urlConnection.getResponseCode() + ": " + stringBuffer.toString());
        }
        return bsrURI;
    }

    private String getReferencedFilename(String responseError) {
        String regEx = "<code>GSR1350E</code><message>GSR0008E:.+&quot;((.+))&quot;";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(responseError);
        if (m.find() && m.groupCount() == 2) {
            return m.group(1);
        }
        return null;
    }

    private String createBusinessService(String createURL, HashMap<String, String> service, String serviceVersionBsrUri, String requirementsDocBsrUri) {
        String bsrURI = null;
        try {
            URL url = new URL(createURL);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            Document document = this.docBuilder.newDocument();
            Element resourcesElement = document.createElement(ELEMENT_RESOURCES);
            document.appendChild(resourcesElement);
            Element resourceElement = document.createElement(ELEMENT_RESOURCE);
            resourcesElement.appendChild(resourceElement);
            Element propertiesElement = document.createElement(ELEMENT_PROPERTIES);
            resourceElement.appendChild(propertiesElement);
            propertiesElement.appendChild(this.createPropertyElement(document, "name", service.get("Name")));
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_DESCRIPTION, service.get("Description")));
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_PRIMARY_TYPE, OWL_URI_BUSINESS_SERVICE));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_ASSET_WEB_LINK, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_FULL_DESCRIPTION, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_REMOTE_STATE, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_ASSET_TYPE, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_REQUIREMENTS_LINK, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_OWNER_EMAIL, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_GUID, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_COMMUNITY_NAME, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_ASSET_OWNERS, EMPTY_STRING));
            Element relationshipsElement = document.createElement(ELEMENT_RELATIONSHIPS);
            resourceElement.appendChild(relationshipsElement);
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_ALE63_DEPENDENCY, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_ALE63_ARTIFACTS, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_ALE63_OWNING_ORGANIZATION, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_SERVICE_INTERFACE_VERSIONS, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_CHARTER, requirementsDocBsrUri));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_CAPABILITY_VERSIONS, serviceVersionBsrUri));
            Element classificationsElement = document.createElement(ELEMENT_CLASSIFICATIONS);
            resourceElement.appendChild(classificationsElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(urlConnection.getOutputStream());
            transformer.transform(source, result);
            System.out.println("+++++++ ");
            InputStream inputStream = urlConnection.getInputStream();
            if (urlConnection.getResponseCode() != 201) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuffer stringBuffer = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                reader.close();
                throw new Exception("Unable to create Business Service: " + service.get("Name") + ": " + stringBuffer.toString());
            }
            bsrURI = this.processResponse(inputStream);
            System.out.println("Successfully created Business Service: " + service.get("Name") + " (" + bsrURI + ")");
            urlConnection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bsrURI;
    }

    private String createServiceVersion(String createURL, HashMap<String, String> service, String wsdlDocBsrUri, String sldBsrUri) {
        String bsrURI = null;
        try {
            URL url = new URL(createURL);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            Document document = this.docBuilder.newDocument();
            Element resourcesElement = document.createElement(ELEMENT_RESOURCES);
            document.appendChild(resourcesElement);
            Element resourceElement = document.createElement(ELEMENT_RESOURCE);
            resourcesElement.appendChild(resourceElement);
            Element propertiesElement = document.createElement(ELEMENT_PROPERTIES);
            resourceElement.appendChild(propertiesElement);
            propertiesElement.appendChild(this.createPropertyElement(document, "name", service.get("Name")));
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_NAMESPACE, service.get("Namespace")));
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_VERSION, service.get("Version")));
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_DESCRIPTION, service.get("Description")));
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_PRIMARY_TYPE, OWL_URI_SERVICE_VERSION));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_ASSET_WEB_LINK, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_FULL_DESCRIPTION, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_REMOTE_STATE, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_ASSET_TYPE, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_REQUIREMENTS_LINK, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_OWNER_EMAIL, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_GUID, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_COMMUNITY_NAME, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_ALE63_ASSET_OWNERS, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_GEP63_CONSUMER_IDENTIFIER, service.get("Service ID")));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_GEP63_VERSION_AVAILABILITY_DATE, service.get("Date in Production")));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_GEP63_VERSION_TERMINATION_DATE, EMPTY_STRING));
            Element relationshipsElement = document.createElement(ELEMENT_RELATIONSHIPS);
            resourceElement.appendChild(relationshipsElement);
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_ALE63_DEPENDENCY, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_ALE63_ARTIFACTS, wsdlDocBsrUri));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_ALE63_OWNING_ORGANIZATION, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_CONSUMES, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_PROVIDES, sldBsrUri));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_INTERFACE_SPECIFICATIONS, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_PROVIDED_SCA_MODULES, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_PROVIDED_WEB_SERVICES, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_PROVIDED_REST_SERVICES, null));
            Element classificationsElement = document.createElement(ELEMENT_CLASSIFICATIONS);
            resourceElement.appendChild(classificationsElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(urlConnection.getOutputStream());
            transformer.transform(source, result);
            System.out.println("+++++++ ");
            InputStream inputStream = urlConnection.getInputStream();
            if (urlConnection.getResponseCode() != 201) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuffer stringBuffer = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                reader.close();
                throw new Exception("Unable to create Service Version: " + service.get("Name") + ": " + stringBuffer.toString());
            }
            bsrURI = this.processResponse(inputStream);
            System.out.println("Successfully created Service Version: " + service.get("Name") + " (" + bsrURI + ")");
            urlConnection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bsrURI;
    }

    private String createServiceLevelDefinition(String createURL, HashMap<String, String> service) {
        String bsrURI = null;
        try {
            URL url = new URL(createURL);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            Document document = this.docBuilder.newDocument();
            Element resourcesElement = document.createElement(ELEMENT_RESOURCES);
            document.appendChild(resourcesElement);
            Element resourceElement = document.createElement(ELEMENT_RESOURCE);
            resourcesElement.appendChild(resourceElement);
            Element propertiesElement = document.createElement(ELEMENT_PROPERTIES);
            resourceElement.appendChild(propertiesElement);
            propertiesElement.appendChild(this.createPropertyElement(document, "name", SLD_NAME_PREFIX + service.get("Name")));
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_PRIMARY_TYPE, OWL_URI_SLD));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_GEP63_CONSUMER_IDENTIFIER_LOCATION, EMPTY_STRING));
            propertiesElement.appendChild(this.createPropertyElement(document, PROPERTY_GEP63_CONTEXT_IDENTIFIER_LOCATION, EMPTY_STRING));
            Object[] inserts = new Object[]{service.get("Version"), service.get("Name")};
            String description = MessageFormat.format(SLD_DESCRIPTION, inserts);
            propertiesElement.appendChild(this.createPropertyElement(document, PropertyConstants_DESCRIPTION, description));
            Element relationshipsElement = document.createElement(ELEMENT_RELATIONSHIPS);
            resourceElement.appendChild(relationshipsElement);
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_BOUND_SCA_EXPORT, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_ANONYMOUS_SLA, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_CAMPATIBLE_SLDS, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_BOUND_WEB_SERVICE_PORT, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_BOUND_REST_SERVICE, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_SERVICE_INTERFACE, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_AVAILABLE_ENDPOINTS, null));
            relationshipsElement.appendChild(this.createRelationshipElement(document, RELATIONSHIP_GEP63_AVAILABLE_OPERATIONS, null));
            Element classificationsElement = document.createElement(ELEMENT_CLASSIFICATIONS);
            resourceElement.appendChild(classificationsElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(urlConnection.getOutputStream());
            transformer.transform(source, result);
            System.out.println("+++++++ ");
            InputStream inputStream = urlConnection.getInputStream();
            if (urlConnection.getResponseCode() != 201) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuffer stringBuffer = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                reader.close();
                throw new Exception("Unable to create Service Level Definition: " + service.get("Name") + ": " + stringBuffer.toString());
            }
            bsrURI = this.processResponse(inputStream);
            System.out.println("Successfully created Service Level Definition: " + service.get("Name") + " (" + bsrURI + ")");
            urlConnection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bsrURI;
    }

    private Element createPropertyElement(Document document, String name, String value) {
        Element element = document.createElement(ELEMENT_PROPERTY);
        element.setAttribute("name", name);
        element.setAttribute(ATTR_VALUE, value);
        return element;
    }

    private Element createRelationshipElement(Document document, String name, String targetBsrUri) {
        Element element = document.createElement(ELEMENT_RELATIONSHIP);
        element.setAttribute("name", name);
        if (targetBsrUri != null) {
            element.setAttribute(ATTR_TARGET_BSRURI, targetBsrUri);
        }
        return element;
    }

    private String processResponse(InputStream inputStream) throws Exception {
        String value = null;
        try {
            Document doc = this.docBuilder.parse(inputStream);
            value = (String)this.valueAttrExpression.evaluate(doc, XPathConstants.STRING);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw e;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw e;
        }
        return value;
    }

    private class MustImportReferenceException
    extends Exception {
        String filename;

        public MustImportReferenceException(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

