#!/usr/bin/env groovy
/*
- Licensed Materials - Property of IBM Corp.
- IBM UrbanCode Deploy
- (c) Copyright IBM Corporation 2014, 2017. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
*/
import java.io.FileNotFoundException
import java.io.IOException
import com.ibm.urbancode.deploy.wsrr.WSDLLoader
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def workDir = new File('.').canonicalFile

def csvFile = props['csvfile'];
println "csvFile: " + csvFile;

def wsdlPath = props['wsdlpath'];
println "wsdlPath: " + wsdlPath;

def hostName = props['hostname'];
println "hostName : " + hostName;

def port = props['port'];
println "port: " + port;

def user = props['user'];
println "user : " + user;

def password = props['password'];
println "password: " + password;


try {
    csvFile = new File(csvFile);
    wsdlPath = new File(wsdlPath);
    def wsdlLoader = new WSDLLoader(csvFile, wsdlPath, hostName, port, user, password);
    wsdlLoader.loadServices();
} catch (NumberFormatException e) {
    e.printStackTrace();
    System.exit(1)
} catch (FileNotFoundException e) {
    e.printStackTrace();
    System.exit(1)
} catch (IOException e) {
    e.printStackTrace();
    System.exit(1)
} catch(Exception e){
    e.printStackTrace();
    System.exit(1)
}
