/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.issr.iet.jmx.OrderedProperties;
import com.ibm.issr.iet.weblogic.JMXEditSession;
import com.ibm.issr.iet.weblogic.WebLogicConnection;
import com.ibm.issr.iet.weblogic.WebLogicHandler;
import com.ibm.issr.iet.weblogic.WebLogicMBeanServer;
import com.ibm.issr.iet.weblogic.WebLogicSecurityHandler;
import com.ibm.issr.iet.weblogic.beans.CreationParam;
import com.ibm.issr.iet.weblogic.beans.JMXBean;
import com.ibm.issr.iet.weblogic.beans.JMXPropertyType;
import com.ibm.issr.iet.weblogic.configuration.WSLMetadata;
import com.ibm.issr.iet.weblogic.security.Operation;
import com.ibm.issr.iet.weblogic.security.Realm;
import com.ibm.issr.iet.weblogic.security.SecurityManagementSAXParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.xml.xpath.XPathExpressionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final String NAME = "name";
    private static final String GROUP = "group";
    private static final String PASSWORD = "password";
    private static final String DESCRIPTION = "description";
    private static final String MEMBER = "member";
    private static final String RESOURCE_ID = "resourceId";
    private static final String EXPRESSION = "expression";
    private static final String AUXILIARY = "auxiliary";
    private static final String ROLE_MAPPER = "RoleMapper";
    private static final String AUTHENTICATION_PROVIDER = "AuthenticationProvider";
    private final String[] args;
    private Properties inputProperties;
    private Properties outputProperties;
    private WebLogicSecurityHandler webLogicSecHandler;
    private OrderedProperties jmxProperties;
    private JMXBean bean;
    private SecurityManagementSAXParser securityParser;
    private WebLogicHandler webLogicHandler;
    private boolean isAuthProvider = false;
    private boolean isRoleMapper = false;
    private boolean isUsersGroups = false;
    private String outputPropsPath;
    private String action;

    public static void main(String[] args) {
        System.exit(new Main(args).execute());
    }

    private Main(String[] args) {
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute() {
        int returnCode;
        int result;
        block64: {
            result = 0;
            returnCode = 0;
            try {
                this.action = this.args[0];
                String beanType = this.args[1];
                String inputPropsPath = this.args[2];
                this.outputPropsPath = this.args[3];
                this.inputProperties = new Properties();
                try {
                    this.inputProperties.load(new FileInputStream(inputPropsPath));
                }
                catch (FileNotFoundException e1) {
                    throw new RuntimeException("Could not locate input properties file at " + inputPropsPath);
                }
                catch (IOException e1) {
                    throw new RuntimeException("Could not load input properties file.");
                }
                this.outputProperties = new Properties();
                this.jmxProperties = new OrderedProperties();
                String hostName = this.inputProperties.getProperty("hostname");
                String port = this.inputProperties.getProperty("port");
                String user = this.inputProperties.getProperty("userid");
                String password = this.inputProperties.getProperty(PASSWORD);
                try {
                    WSLMetadata.initialize(this.inputProperties.getProperty("wlsMetadataXML"));
                }
                catch (AttributeNotFoundException e) {
                    System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                    returnCode = 1;
                }
                catch (XPathExpressionException e) {
                    System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                    returnCode = 1;
                }
                catch (ClassNotFoundException e) {
                    System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                    returnCode = 1;
                }
                catch (IOException e) {
                    System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                    returnCode = 1;
                }
                if (returnCode > 0) {
                    System.out.println("WSL Metadata initialization Failed.");
                    int e = returnCode;
                    return e;
                }
                try {
                    this.webLogicSecHandler = new WebLogicSecurityHandler(new WebLogicConnection(hostName, port, user, password, WebLogicMBeanServer.RUNTIME));
                    this.webLogicHandler = new WebLogicHandler(new WebLogicConnection(hostName, port, user, password, WebLogicMBeanServer.EDIT));
                }
                catch (MalformedURLException e) {
                    System.err.println(String.format("Error connection to WebLogic, bad URL: %s", e.getMessage()));
                    returnCode = 1;
                }
                catch (IOException e) {
                    System.err.println(String.format("Unable to connect to WebLogic: %s", e.getMessage()));
                    returnCode = 1;
                }
                if (returnCode > 0) {
                    System.out.println("Failure Connecting to WebLogic.");
                    int e = returnCode;
                    return e;
                }
                if (beanType.equalsIgnoreCase("users")) {
                    String userProps = this.inputProperties.getProperty("usersProperties");
                    this.securityParser = new SecurityManagementSAXParser(userProps, AUTHENTICATION_PROVIDER);
                    this.isUsersGroups = true;
                    this.bean = WSLMetadata.getInstance().getJMXBean(AUTHENTICATION_PROVIDER);
                } else if (beanType.equalsIgnoreCase("roles")) {
                    String roleProps = this.inputProperties.getProperty("roleProperties");
                    this.securityParser = new SecurityManagementSAXParser(roleProps, ROLE_MAPPER);
                    this.bean = WSLMetadata.getInstance().getJMXBean(ROLE_MAPPER);
                } else {
                    String jmxPropsPath = this.inputProperties.getProperty("jmxProperties");
                    try {
                        this.jmxProperties.load(new FileInputStream(jmxPropsPath));
                    }
                    catch (FileNotFoundException e1) {
                        throw new RuntimeException("Could not locate jmx properties file at " + jmxPropsPath);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException("Could not load jmx properties file.");
                    }
                    this.bean = WSLMetadata.getInstance().getJMXBean(beanType);
                }
                if (this.bean != null) {
                    if (this.bean.getName().equals(AUTHENTICATION_PROVIDER)) {
                        this.isAuthProvider = true;
                    } else if (this.bean.getName().equals(ROLE_MAPPER)) {
                        this.isRoleMapper = true;
                    }
                }
                List<Realm> realmsToProcess = null;
                if (this.securityParser != null) {
                    realmsToProcess = this.securityParser.getRealms();
                    this.bean = null;
                }
                if (realmsToProcess != null) {
                    for (Realm realm : realmsToProcess) {
                        ObjectName provider = null;
                        try {
                            if (this.isAuthProvider) {
                                provider = this.webLogicSecHandler.lookupAuthenticationProvider(realm.getName(), realm.getProvider());
                            } else if (this.isRoleMapper) {
                                provider = this.webLogicSecHandler.lookupRoleMapper(realm.getName(), realm.getProvider());
                            }
                        }
                        catch (AttributeNotFoundException e) {
                            throw new RuntimeException("Cannot find provider with realm name " + realm.getName());
                        }
                        catch (MalformedObjectNameException e) {
                            throw new RuntimeException("Bad Object Name");
                        }
                        catch (InstanceNotFoundException e) {
                            throw new RuntimeException("Instance not found");
                        }
                        catch (IntrospectionException e) {
                            throw new RuntimeException("Introspection error.");
                        }
                        catch (MBeanException e) {
                            throw new RuntimeException("Bean Error.");
                        }
                        catch (ReflectionException e) {
                            throw new RuntimeException("Relfection error.");
                        }
                        catch (IOException e) {
                            throw new RuntimeException("IO error.");
                        }
                        if (provider == null) {
                            System.out.println(String.format("Unable to find %s on the realm %s", realm.getProvider(), realm.getName()));
                            continue;
                        }
                        this.performSecurityAction(realm, provider);
                        System.out.println("Security Action performed");
                    }
                    break block64;
                }
                returnCode = this.updateOrCreate();
            }
            catch (RuntimeException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                result = 1;
            }
            finally {
                if (this.webLogicSecHandler != null) {
                    this.webLogicSecHandler.closeConnection();
                }
                if (this.webLogicHandler != null) {
                    this.webLogicHandler.closeConnection();
                }
                File outputPropertiesFile = new File(this.outputPropsPath);
                try {
                    FileOutputStream outputPropertiesStream = new FileOutputStream(outputPropertiesFile);
                    this.outputProperties.store(outputPropertiesStream, "");
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not locate output properties file at " + this.outputPropsPath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not load properties file");
                }
            }
        }
        if (returnCode > 0) {
            result = returnCode;
        }
        return result;
    }

    private String getPath(boolean isNameReference) {
        StringBuilder pathBuilder = new StringBuilder(this.bean.getPath());
        for (String param : this.bean.getParams()) {
            int paramStart = pathBuilder.indexOf("$" + param);
            int paramEnd = paramStart + param.length() + 1;
            if (isNameReference && this.bean.getName().equals(param)) {
                param = param + "Name";
            }
            pathBuilder.replace(paramStart, paramEnd, this.inputProperties.getProperty(param));
        }
        return pathBuilder.toString();
    }

    protected ObjectName getBean(String resourcePath, JMXEditSession editSession, Map<Object, String> params) throws InstanceNotFoundException, MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, IllegalArgumentException, IOException {
        ObjectName createdBean = null;
        try {
            String searchPath = resourcePath;
            if (this.isAuthProvider || this.isRoleMapper) {
                searchPath = this.getPath(true);
            }
            createdBean = this.webLogicHandler.navigateTo(editSession.getDomainConfigRoot(), searchPath);
        }
        catch (IllegalArgumentException e) {
            createdBean = this.webLogicHandler.create(editSession.getDomainConfigRoot(), resourcePath.toString(), params);
            System.out.println(String.format("Bean created at /%s", resourcePath.toString()));
        }
        return createdBean;
    }

    private void performSecurityAction(Realm realm, ObjectName provider) {
        for (Map.Entry<Operation, List<Map<String, String>>> entry : realm.getOperations().entrySet()) {
            for (Map<String, String> parameters : entry.getValue()) {
                try {
                    switch (entry.getKey()) {
                        case createUser: {
                            this.webLogicSecHandler.createUser(provider, parameters.get(NAME), parameters.get(PASSWORD), parameters.get(DESCRIPTION));
                            break;
                        }
                        case removeUser: {
                            this.webLogicSecHandler.removeUser(provider, parameters.get(NAME));
                            break;
                        }
                        case createGroup: {
                            this.webLogicSecHandler.createGroup(provider, parameters.get(NAME), parameters.get(DESCRIPTION));
                            break;
                        }
                        case removeGroup: {
                            this.webLogicSecHandler.removeGroup(provider, parameters.get(NAME));
                            break;
                        }
                        case addMemberToGroup: {
                            this.webLogicSecHandler.addUserToGroup(provider, parameters.get(GROUP), parameters.get(MEMBER));
                            break;
                        }
                        case removeMemberFromGroup: {
                            this.webLogicSecHandler.removeUserFromGroup(provider, parameters.get(GROUP), parameters.get(MEMBER));
                            break;
                        }
                        case createRole: {
                            this.webLogicSecHandler.createRole(provider, parameters.get(RESOURCE_ID), parameters.get(NAME), parameters.get(EXPRESSION), parameters.get(AUXILIARY));
                            break;
                        }
                        case removeRole: {
                            this.webLogicSecHandler.removeRole(provider, parameters.get(RESOURCE_ID), parameters.get(NAME));
                            break;
                        }
                        case setRoleAuxiliary: {
                            this.webLogicSecHandler.setRoleAuxiliary(provider, parameters.get(RESOURCE_ID), parameters.get(NAME), parameters.get(AUXILIARY));
                            break;
                        }
                        case setRoleExpression: {
                            this.webLogicSecHandler.setRoleExpression(provider, parameters.get(RESOURCE_ID), parameters.get(NAME), parameters.get(EXPRESSION));
                        }
                    }
                }
                catch (InstanceNotFoundException e) {
                    throw new RuntimeException("Instance not found while performing security action");
                }
                catch (ReflectionException e) {
                    throw new RuntimeException("Reflection Error while performing security action");
                }
                catch (MBeanException e) {
                    System.out.println(e.getMessage() + " " + e.getStackTrace());
                    throw new RuntimeException("Bean Error while performing security action.");
                }
                catch (IOException e) {
                    throw new RuntimeException("IO error while performing security action.");
                }
            }
        }
    }

    public int updateOrCreate() {
        JMXEditSession editSession;
        System.out.println("Updating or creating");
        try {
            editSession = this.webLogicHandler.getEditSession("EditService");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Bad Object Name while getting edit session");
        }
        catch (MBeanException e) {
            throw new RuntimeException("Bean Error while getting edit session.");
        }
        catch (ReflectionException e) {
            throw new RuntimeException("Reflection Error while getting edit session");
        }
        catch (OperationsException e) {
            throw new RuntimeException("Operations Error while getting edit session");
        }
        catch (IOException e) {
            throw new RuntimeException("IO error while getting edit session");
        }
        String pathBuilder = this.getPath(false);
        TreeMap<Object, String> params = new TreeMap<Object, String>();
        try {
            JMXBean pathBean;
            if (!this.action.equalsIgnoreCase("create") && !this.action.equalsIgnoreCase("update")) {
                System.out.println(String.format("The action type %s is not supported", this.action));
                return 1;
            }
            if (this.action.equals("create") && (pathBean = WSLMetadata.getInstance().getJMXBean(this.webLogicHandler.getBeanTypeFromPath(pathBuilder))).hasCreationParams()) {
                for (CreationParam creationParam : pathBean.getCreationParams()) {
                    Object param = JMXPropertyType.parse(this.inputProperties.getProperty(creationParam.getName()), creationParam.getType(), false);
                    String paramType = creationParam.getType().getClassType().getCanonicalName();
                    params.put(param, paramType);
                }
            }
            ObjectName objectBean = this.getBean(pathBuilder, editSession, params);
            this.webLogicHandler.updateProperties(this.jmxProperties, objectBean, this.bean, this.inputProperties);
            System.out.println(String.format("%s %s updated at %s", this.bean.getName(), this.webLogicHandler.getObjectNameFromPath(pathBuilder.toString()), this.webLogicHandler.getParentPath(pathBuilder)));
            try {
                this.webLogicHandler.comitChanges(editSession, true, true);
            }
            catch (Exception e) {
                this.webLogicHandler.cancelChanges(editSession);
            }
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException("Instance not found while updating.");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Bad Object Name while updating.");
        }
        catch (AttributeNotFoundException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException("Attribute Not Found error while updating.");
        }
        catch (MBeanException e) {
            throw new RuntimeException("Bean Error while updating.");
        }
        catch (ReflectionException e) {
            throw new RuntimeException("Reflection Error while updating.");
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException("Illegal Argument while updating.");
        }
        catch (IOException e) {
            throw new RuntimeException("IO error while updating.");
        }
        catch (InvalidAttributeValueException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException("Illegal Argument while updating.");
        }
        return 0;
    }
}

