/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic.beans;

import com.ibm.issr.iet.util.xml.XMLUtils;
import com.ibm.issr.iet.weblogic.beans.JMXProperty;
import javax.management.AttributeNotFoundException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JMXAttribute
extends JMXProperty {
    private String validatedBy;
    protected boolean isArray = false;
    private boolean isReadOnly = false;

    protected JMXAttribute(String name, String type, String validatedBy, String readOnly) throws ClassNotFoundException {
        super(name, type);
        if (type.matches(".*\\[]")) {
            this.isArray = true;
        }
        this.validatedBy = validatedBy;
        this.isReadOnly = Boolean.parseBoolean(readOnly);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getValidatedBy() {
        return this.validatedBy;
    }

    public boolean hasValidatedBy() {
        return !"".equals(this.validatedBy);
    }

    public static JMXAttribute loadFromNode(Node node, XMLUtils xmlUtils) throws ClassNotFoundException, AttributeNotFoundException {
        Element jmxBeanProperty = (Element)node;
        String name = jmxBeanProperty.getAttribute("name");
        String type = jmxBeanProperty.getAttribute("type");
        String readonly = jmxBeanProperty.getAttribute("readonly");
        String validatedBy = jmxBeanProperty.getAttribute("validatedBy");
        JMXAttribute property = new JMXAttribute(name, type, validatedBy, readonly);
        return property;
    }
}

