import java.io.*;
import java.util.*;

def invokeBPMInstall(invokeArgs, commandArgs, isWindows) {
	File tempFile = new File("temp.py")
	tempFile.deleteOnExit()
	BufferedWriter temp = new BufferedWriter(new FileWriter(tempFile))
	def invoke = "AdminTask.BPMInstall('" + invokeArgs + "]')"
	temp.write(invoke, 0, invoke.length())
	System.out.println invoke
	temp.close()
	println commandArgs.join(' ');
	def procBuilder = new ProcessBuilder(commandArgs);

	if (isWindows) {
		def envMap = procBuilder.environment();
		envMap.put("PROFILE_CONFIG_ACTION","true");
	}

	def statusProc = procBuilder.start();
	def outPrint = new PrintStream(System.out, true);
	statusProc.waitForProcessOutput(outPrint, outPrint);
	tempFile.delete()
	return statusProc.exitValue()
}

//////////////////////MAIN////////////////////////
def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
final def props = new Properties()
final def inputPropsFile = new File(args[0])
final def inputPropsStream = null
try {
    inputPropsStream = new FileInputStream(inputPropsFile)
    props.load(inputPropsStream)
}
catch (IOException e) {
    throw new RuntimeException(e)
}

def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"
def port = props['port']
def user = props['user']
def password = props['password']
def connType = props['connType']
def profHome = props['profileRoot']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
	profHome = profHome + File.separator
}
def commandPath = profHome + "bin" + File.separator + wsadmin
def containerSnapshotAcronym = props['containerSnapshotAcronym']
def containerTrackAcronym = props['containerTrackAcronym']
def skipGovernance = props['skipGovernance']
def containerAcronym = props['containerAcronym']
if (containerAcronym == null || containerAcronym.equals("") ) {
	containerAcronym = new File(".").getCanonicalFile().name //this gets resolved to component name
}

def commandArgs = [commandPath, "-lang", "jython"];
commandArgs << "-conntype"
commandArgs << connType.trim();
commandArgs << "-port";
commandArgs << port;
if (!props['useSOAPProps'].equals("true")) {
	commandArgs << "-user"
    commandArgs <<  user
    commandArgs << "-password"
    commandArgs << password
}
commandArgs << "-f";
commandArgs << "temp.py";

def invokeArgs = '[ -containerAcronym ' + containerAcronym + ' -containerSnapshotAcronym ' + containerSnapshotAcronym + ' -containerTrackAcronym ' + containerTrackAcronym
if (!skipGovernance.equals("false")) {
	invokeArgs = invokeArgs + ' -skipGovernance ' + skipGovernance
}

def servers = props['servers']
def onlineServers = servers.split(",")
for (onlineServer in onlineServers) {
	def retCode = invokeBPMInstall(invokeArgs + ' -serverName ' + onlineServer, commandArgs, isWindows)
	if (retCode != 0) {
		System.exit(retCode)
	}
}
