import java.io.*;
import java.util.*;

def isEmpty(value) {
	return value == null || value.equals("")
}

//////////////////////MAIN////////////////////////
final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
final def workDir = new File('.').canonicalFile
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name
final def props = new Properties()
final def inputPropsFile = new File(args[0])
final def inputPropsStream = null
try {
    inputPropsStream = new FileInputStream(inputPropsFile)
    props.load(inputPropsStream)
}
catch (IOException e) {
    throw new RuntimeException(e)
}

def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"
def port = props['port']
def user = props['user']
def password = props['password']
def connType = props['connType']
def profHome = props['profileRoot']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
	profHome = profHome + File.separator
}
def commandPath = profHome + "bin" + File.separator + wsadmin
def appPackage = props['package']
if (!(appPackage =~ /(?i)\.zip/)) {
	appPackage = appPackage + ".zip"
}

def commandArgs = [commandPath, "-lang", "jython"];
commandArgs << "-conntype"
commandArgs << connType.trim();
commandArgs << "-port";
commandArgs << port;
if (!props['useSOAPProps'].equals("true")) {
	commandArgs << "-user"
    commandArgs <<  user
    commandArgs << "-password"
    commandArgs << password
}
commandArgs << "-f";
commandArgs << "temp.py";

def invokeArgs = '[ -inputFile ' + workDir + File.separator + appPackage
def invoke = "AdminTask.BPMInstallOfflinePackage('" + invokeArgs + "]')"

File tempFile = new File("temp.py")
tempFile.deleteOnExit()
BufferedWriter temp = new BufferedWriter(new FileWriter(tempFile))
temp.write(invoke, 0, invoke.length())
System.out.println invoke
temp.close()
println commandArgs.join(' ');
def procBuilder = new ProcessBuilder(commandArgs);

if (isWindows) {
	def envMap = procBuilder.environment();
	envMap.put("PROFILE_CONFIG_ACTION","true");
}

def statusProc = procBuilder.start();
def outPrint = new PrintStream(System.out, true);
statusProc.waitForProcessOutput(outPrint, outPrint);
System.exit(statusProc.exitValue());
