/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def ch = new CommandHelper(new File("."))
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

def appPackage = props['package']
if (appPackage == null || appPackage.equals("")) {
    appPackage = compName
}
if (!(appPackage =~ /(?i)\.twx/)) {
    appPackage = appPackage + ".twx"
}

def infile = workDir.toString() + File.separator + appPackage
infile = infile.replace('\\', '/')
def invokeArgs = '[ -inputFile ' + '"' + infile + '"'
def invoke = "AdminTask.BPMImport('" + invokeArgs + "]')"
def exitVal = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)

System.exit(exitVal)
