/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
final def ch = new CommandHelper(workDir)
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = workDir.getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

////////////// BPM Command Arguments /////////////
def serverName = props['serverName']
def containerSnapshotAcronym = props['containerSnapshotAcronym']
def containerTrackAcronym = props['containerTrackAcronym']
def containerAcronym = props['containerAcronym']

// Retrieve snapshot acronym if name is given
containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
containerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerSnapshotAcronym, containerAcronym, commandArgs)
containerTrackAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerTrackAcronym, containerAcronym, commandArgs)

//////// Construct the BPMDeactivate Command ////////
def containerAcronymArgs = "-containerAcronym ${containerAcronym}"
def containerSnapshotAcronymArgs = "-containerSnapshotAcronym ${containerSnapshotAcronym}"
def containerTrackAcronymArgs = "-containerTrackAcronym ${containerTrackAcronym}"
def serverNameArgs = "-serverName \"${serverName}\""


def invoke = "AdminTask.BPMUpdateInstallationInformation('[${containerAcronymArgs} ${containerSnapshotAcronymArgs} " +
        "${containerTrackAcronymArgs} ${serverNameArgs}]')"
def exitVal = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)

System.exit(exitVal)
