/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def ch = new CommandHelper(new File("."))

final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

def containerSnapshotAcronym = props['containerSnapshotAcronym']
def containerTrackAcronym = props['containerTrackAcronym']
def containerAcronym = props['containerAcronym']
if (!containerAcronym) {
    containerAcronym = compName
}

containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
containerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerSnapshotAcronym, containerAcronym, commandArgs)
containerTrackAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerTrackAcronym, containerAcronym, commandArgs)

def skipGovernance = props['skipGovernance']
def invokeArgs = '[ -containerAcronym ' + containerAcronym + ' -containerSnapshotAcronym ' + containerSnapshotAcronym + ' -containerTrackAcronym ' + containerTrackAcronym
if (!skipGovernance.equals("false")) {
    invokeArgs = invokeArgs + ' -skipGovernance ' + skipGovernance
}

def servers = props['servers']
def onlineServers = servers.split(",")
for (onlineServer in onlineServers) {
    def invoke = "AdminTask.BPMInstall('" + invokeArgs + ' -serverName ' + '"' + onlineServer + '"' + "]')"
    def retCode = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)
    if (retCode != 0) {
        System.exit(retCode)
    }
}
