/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
final def ch = new CommandHelper(workDir)
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = workDir.getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

////////////// BPM Command Arguments /////////////
def installPackageFile = props['installPackageFile']
def packagePathString = WebSphereBPMHelper.getFilePath(installPackageFile, workDir)

if (!packagePathString) {
    println "'${installPackageFile}' is an invalid Install Package."
    System.exit(1)
}
else if (!packagePathString.endsWith(".zip")) {
    println "'${packagePathString} is not a valid Install Package that ends with '.zip'."
    System.exit(1)
}
def showSnapshotInfo = Boolean.valueOf(props['showSnapshotInfo'])

//////// Construct the BPMInstallPackage Command ////////
def inputFileArgs = "-inputFile \"${packagePathString}\""
def showSnapshotInfoArgs = "-showSnapshotInfo ${showSnapshotInfo}"

def invoke = "AdminTask.BPMInstallPackage('[${inputFileArgs} ${showSnapshotInfoArgs}]')"
def exitVal = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)

System.exit(exitVal)