package com.urbancode.air.plugin.websphere.bpm

import java.io.File
import java.io.BufferedWriter
import java.io.FileWriter

class WebSphereBPMHelper {

    public static boolean isEmpty(String val) {
        return val == null || val.equals("")
    }

    /**
     * @param container The name of the process application
     * @param commandArgs The args for the wsadmin command
     * @return The acronym/short name of the application
     *         If the acronym itself is passed to the method, it is returned as is.
     */
    public static String getContainerAcronym(def container, def commandArgs) {
        def command = "AdminTask.BPMListProcessApplications()"
        return getAcronym(command, commandArgs, container)
    }

    /**
     *
     * @param snapshot The name of the process application snapshot/track
     * @param container The name of the process application
     * @param commandArgs The args for the wsadmin command
     * @return The acronym/short name of the application snapshot/track.
     *         If the acronym itself is passed to the method, it is returned as is.
     */
    public static String getSnapshotTrackAcronym(def snapshot, def container, def commandArgs) {
        def command = "AdminTask.BPMShowProcessApplication('[-containerAcronym " + container + "]')"
        return getAcronym(command, commandArgs, snapshot)
    }

    /**
     * 
     * @param command The wsadmin command to invoke to find the acronym
     * @param commandArgs The args for the wsadmin command 
     * @param name The name of the process application/snapshot/track
     * @return The acronym/short name of the application/snapshot/track.
     *         If the acronym itself is passed to the method, it is returned as is.
     */
    private static String getAcronym(def command, def commandArgs, def name) {
        def wsadminOutput = runWsadmin(command, commandArgs)
        def pattern = "(Track\\s+)?(Name|Acronym)\\s*:\\s*" + name + "([\\s\\\\n\\\\t]*(Track\\s+)?Acronym\\s*:\\s*(.+?)\\\\n)*"
        def matcher = wsadminOutput =~ pattern
        if (matcher.find()) {
            if (matcher[0][2] == "Name") {
                return matcher[0][5]
            }
            return name.toString()
        }
        return ""
    }

    private static String runWsadmin(def command, def commandArgs) {
        File tempFile = new File("temp.py")
        tempFile.deleteOnExit();
        BufferedWriter temp = new BufferedWriter(new FileWriter(tempFile))
        temp.writeLine("print " + command)
        temp.close()

        def procBuilder = new ProcessBuilder(commandArgs)
        def statusProc = procBuilder.start()
        def reader = new BufferedReader(new InputStreamReader(statusProc.getInputStream()))
        def outputLines = ""
        def line = reader.readLine()
        while (line != null) {
            outputLines = outputLines + line + "\\n"
            line = reader.readLine()
        }
        tempFile.delete()
        return outputLines.toString()
    }
}
