/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.iterator.files.Files;
import com.urbancode.commons.util.logging.LogUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FileListerBase
extends FileLister {
    private static final Logger log = Logger.getLogger(FileListerBase.class);
    private static FileFilter DIRECTORY_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static FileFilter DIRECTORY_SKIP_LINKS_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            try {
                return file.isDirectory() && !FileUtils.isSymlink(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final File base;
    private final Iterable<File> files;
    private final PermissionReader permissionReader;

    FileListerBase(File base, FileFilter filter, PermissionReader permissionReader) throws IOException {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        if (permissionReader == null) {
            throw new NullPointerException("permissionReader");
        }
        this.base = base.getCanonicalFile();
        this.permissionReader = permissionReader;
        FileFilter traverser = this.createTraverseFilter();
        this.files = Files.eachFile(base, traverser, filter);
    }

    @Override
    public File base() {
        return this.base;
    }

    @Override
    public List<TypedFile> list() throws IOException {
        ArrayList<TypedFile> result = new ArrayList<TypedFile>();
        this.list(result);
        return result;
    }

    protected abstract boolean includeInList(TypedFile var1) throws IOException;

    protected abstract TypedFile normalize(TypedFile var1) throws IOException;

    protected Set<?> getPermissions(File file) throws IOException {
        file = file.getCanonicalFile();
        return this.permissionReader.getPermissions(file);
    }

    protected Set<?> getPermissions(TypedFile file) throws IOException {
        File actualFile = file.translate(this.base());
        return this.getPermissions(actualFile);
    }

    private void list(List<TypedFile> result) throws IOException {
        for (File file : this.files) {
            TypedFile typed = null;
            typed = this.createTypedFile(file);
            if (!this.includeInList(typed)) continue;
            LogUtil.logTrace(log, file.getAbsolutePath() + " matched, adding to result");
            result.add(this.normalize(typed));
        }
    }

    private TypedFile createTypedFile(File file) throws IOException {
        LogUtil.logTrace(log, "Creating TypedFile for " + file);
        String path = this.relativize(file);
        Set<?> permissions = this.getPermissions(file);
        return TypedFile.create(this.base(), path, permissions);
    }

    private String relativize(File file) {
        int basePathLength = this.base().getPath().length();
        if (!this.isBaseRoot()) {
            int separatorLength = 1;
            basePathLength += separatorLength;
        }
        return file.getPath().substring(basePathLength).replace('\\', '/');
    }

    private boolean isBaseRoot() {
        return this.base().getParent() == null;
    }

    abstract boolean isSymLinkAware();

    private FileFilter createTraverseFilter() {
        FileFilter traverser = this.isSymLinkAware() ? DIRECTORY_SKIP_LINKS_FILE_FILTER : DIRECTORY_FILE_FILTER;
        return traverser;
    }
}

