/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def ch = new CommandHelper(new File("."))
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name

def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"
def port = props['port']
def user = props['user']
def password = props['password']
def connType = props['connType']
def profHome = props['profileRoot']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
    profHome = profHome + File.separator
}
def commandPath = profHome + "bin" + File.separator + wsadmin
def appPackage = props['package']
if (appPackage == null || appPackage.equals("")) {
    appPackage = compName
}
if (!(appPackage =~ /(?i)\.twx/)) {
    appPackage = appPackage + ".twx"
}

def infile = workDir.toString() + File.separator + appPackage
infile = infile.replace('\\', '/')
def invokeArgs = '[ -inputFile ' + '"' + infile + '"'
def invoke = "AdminTask.BPMImport('" + invokeArgs + "]')"
def exitVal = 0

try {
    File tempFile = new File("temp.py")
    tempFile.deleteOnExit()
    BufferedWriter temp = new BufferedWriter(new FileWriter(tempFile))
    temp.write(invoke, 0, invoke.length())
    temp.close()
}
catch (IOException ioe) {
    exitVal = 1
    ioe.printStackTrace()
}

def commandArgs = [commandPath, "-lang", "jython"];
commandArgs << "-conntype"
commandArgs << connType.trim()
commandArgs << "-port"
commandArgs << port;
if (!props['useSOAPProps'].equals("true")) {
    commandArgs << "-user"
    commandArgs <<  user
    commandArgs << "-password"
    commandArgs << password
}
commandArgs << "-f";
commandArgs << "temp.py";

try {
    if (isWindows) {
        ch.addEnvironmentVariable("PROFILE_CONFIG_ACTION", "true")
    }
    ch.runCommand(invoke, commandArgs)

} catch (Exception e) {
    e.printStackTrace()
    exitVal = 1
}
System.exit(exitVal)
