/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def ch = new CommandHelper(new File("."))
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

////////////// BPM Command Arguments /////////////
def containerSnapshotAcronym = props['containerSnapshotAcronym']
def containerAcronym = props['containerAcronym']

// Retrieve snapshot acronym if name is given
containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
containerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerSnapshotAcronym, containerAcronym, commandArgs)

//////// Construct the BPMStop Command ////////
def containerAcronymArgs = "-containerAcronym ${containerAcronym}"
def containerSnapshotAcronymArgs = "-containerSnapshotAcronym ${containerSnapshotAcronym}"

def invoke = "AdminTask.BPMStop('[${containerAcronymArgs} ${containerSnapshotAcronymArgs}]')"
def exitVal = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)

System.exit(exitVal)