/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def ch = new CommandHelper(new File("."))
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

////////////// BPM Command Arguments /////////////
def sourceContainerSnapshotAcronym = props['sourceContainerSnapshotAcronym']
def targetContainerSnapshotAcronym = props['targetContainerSnapshotAcronym']
def containerAcronym = props['containerAcronym']

// Retrieve snapshot acronym if name is given
containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
sourceContainerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(sourceContainerSnapshotAcronym, containerAcronym, commandArgs)
targetContainerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(targetContainerSnapshotAcronym, containerAcronym, commandArgs)

//////// Construct the BPMSync Commands ////////
def containerAcronymArgs = "-containerAcronym ${containerAcronym}"
def sourceContainerSnapshotAcronymArgs = "-sourceContainerSnapshotAcronym \"${sourceContainerSnapshotAcronym}\""
def targetContainerSnapshotAcronymArgs = "-targetContainerSnapshotAcronym \"${targetContainerSnapshotAcronym}\""

def exitVals = []
def invoke

//////// Construct the BPMSyncEnvironmentVariables Command ////////
if (Boolean.valueOf(props['syncEnvironmentVariables'])) {
    println "Running BPMSyncEnvironmentVariables..."
    invoke = "AdminTask.BPMSyncEnvironmentVariables('[${containerAcronymArgs} " +
        "${sourceContainerSnapshotAcronymArgs} ${targetContainerSnapshotAcronymArgs}]')"
    exitVals << WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)
}

//////// Construct the BPMSyncEPVValues Command ////////
if (Boolean.valueOf(props['syncEPVValues'])) {
    println "Running BPMSyncEPVValues..."
    invoke = "AdminTask.BPMSyncEPVValues('[${containerAcronymArgs} " +
        "${sourceContainerSnapshotAcronymArgs} ${targetContainerSnapshotAcronymArgs}]')"
    exitVals << WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)
}

//////// Construct the BPMSyncTeamBindings Command ////////
if (Boolean.valueOf(props['syncTeamBindings'])) {
    println "Running BPMSyncTeamBindings..."
    invoke = "AdminTask.BPMSyncTeamBindings('[${containerAcronymArgs} " +
        "${sourceContainerSnapshotAcronymArgs} ${targetContainerSnapshotAcronymArgs}]')"
    exitVals << WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)
}

if (exitVals.size() == 0) {
    println "No sync commands were specified."
}

if (exitVals.contains(1) || exitVals.contains(-1)) {
    System.exit(1)
}