/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def ch = new CommandHelper(new File("."))
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

////////////// BPM Command Arguments /////////////
def containerSnapshotAcronym = props['containerSnapshotAcronym']
def containerTrackAcronym = props['containerTrackAcronym']
def containerAcronym = props['containerAcronym']

// Retrieve snapshot acronym if name is given
containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
containerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerSnapshotAcronym, containerAcronym, commandArgs)
containerTrackAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerTrackAcronym, containerAcronym, commandArgs)

// Construct the target package file path
def packageZipFile = props['packageZipFile']
if (!packageZipFile) {
    packageZipFile = containerAcronym + ".zip"
}
else if (!packageZipFile.endsWith(".zip")) {
    println "The Package Zip file '${packageZipFile}' must end with a .zip extension."
    System.exit(1)
}

// Does zip file exist? If so, delete it and get its full path.
def packagePathString = WebSphereBPMHelper.getRemovedFilePath(packageZipFile, workDir)

//////// Construct the BPMExportInstallPackage Command ////////
def containerAcronymArgs = "-containerAcronym ${containerAcronym}"
def containerSnapshotAcronymArgs = "-containerSnapshotAcronym ${containerSnapshotAcronym}"
def containerTrackAcronymArgs = "-containerTrackAcronym ${containerTrackAcronym}"
def outputFileArgs = "-outputFile \"${packagePathString}\""

def invoke = "AdminTask.BPMExportInstallPackage('[${containerAcronymArgs} " +
            "${containerSnapshotAcronymArgs} ${containerTrackAcronymArgs} ${outputFileArgs}]')"
def exitVal = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)

// Check if package zip was created
packageFile = new File(packagePathString)
if (!packageFile.isFile()) {
    println "The Package Zip file '${packageZipFile}' was not created."
    exitVal = 1
}

System.exit(exitVal)