/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2014, 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
final def ch = new CommandHelper(workDir)
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = workDir.getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

////////////// BPM Command Arguments /////////////
def logFile = props['logFile']
def containerSnapshotAcronym = props['containerSnapshotAcronym']
def containerTrackAcronym = props['containerTrackAcronym']
def containerAcronym = props['containerAcronym']

// Retrieve snapshot acronym if name is given
containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
containerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerSnapshotAcronym, containerAcronym, commandArgs)
// Optional parameter
if (containerTrackAcronym) {
    containerTrackAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerTrackAcronym, containerAcronym, commandArgs)
}
//////// Construct the BPMDeactivate Command ////////
def containerAcronymArgs = "-containerAcronym ${containerAcronym}"
def containerSnapshotAcronymArgs = "-containerSnapshotAcronym ${containerSnapshotAcronym}"
def containerTrackAcronymArgs = ""
// Optional parameter
if (containerTrackAcronym) {
    containerTrackAcronymArgs = "-containerTrackAcronym ${containerTrackAcronym}"
}
def forceArgs = ""
if (Boolean.valueOf(props['force'])) {
    forceArgs = "-force"
}

def suspendAllBPDInstancesArgs = ""
if (Boolean.valueOf(props['suspendAllBPDInstances'])) {
    if (containerSnapshotAcronym == "Tip") {
        println "The argument '-suspendAllBPDInstances' cannot be specified if 'Tip' is the containerSnapshotAcronym."
    }
    else {
        suspendAllBPDInstancesArgs = "-suspendAllBPDInstances"
    }
}

def outputFileArgs = ""
if (logFile) {
    // Create unique logfile name
    def logPathString = WebSphereBPMHelper.createUniqueFileName(logFile, workDir)
    println "Creating Log File: " + logPathString
    outputFileArgs = "-outputFile \"${logPathString}\""
}

def invoke = "AdminTask.BPMDeactivate('[${containerAcronymArgs} ${containerSnapshotAcronymArgs} " +
        "${containerTrackAcronymArgs} ${forceArgs} ${suspendAllBPDInstancesArgs} ${outputFileArgs}]')"
def exitVal = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)

System.exit(exitVal)
