/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

def invokeCommand(invoke, commandArgs, isWindows, ch) {
    def exitVal = 0
    try {
        File tempFile = new File("temp.py")
        tempFile.deleteOnExit()
        BufferedWriter temp = new BufferedWriter(new FileWriter(tempFile))
        temp.write(invoke, 0, invoke.length())
        temp.close()

        if (isWindows) {
            ch.addEnvironmentVariable("PROFILE_CONFIG_ACTION", "true")
        }
        ch.runCommand(invoke, commandArgs)

        tempFile.delete()
    } catch (Exception e) {
        e.printStackTrace()
        exitVal = 1
    }
    return exitVal
}

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def ch = new CommandHelper(new File("."))
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = new File(".").getCanonicalFile().name //this gets resolved to component name

WebSphereBPMHelper.setVerbose(Boolean.valueOf(props['verbose']))

def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"
def port = props['port']
def user = props['user']
def host = props['host']
def password = props['password']
def connType = props['connType']
def profHome = props['profileRoot']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
    profHome = profHome + File.separator
}
def commandPath = profHome + "bin" + File.separator + wsadmin
def appPackage = props['package']
if (!(appPackage =~ /(?i)\.zip/)) {
    appPackage = appPackage + ".zip"
}

def infile = workDir.toString() + File.separator + appPackage
infile = infile.replace('\\', '/')
def invokeArgs = '[ -inputFile ' + '"' + infile + '"'
def invoke = "AdminTask.BPMInstallOfflinePackage('" + invokeArgs + "]')"

def commandArgs = [
    commandPath,
    "-lang",
    "jython"
];
commandArgs << "-conntype"
commandArgs << connType.trim()
commandArgs << "-port"
commandArgs << port

if (!props['useSOAPProps'].equals("true")) {
    commandArgs << "-user"
    commandArgs <<  user
    commandArgs << "-password"
    commandArgs << password
}

if (host) {
    commandArgs << "-host"
    commandArgs << host
}

commandArgs << "-f"
commandArgs << "temp.py"

def makeDefault = Boolean.valueOf(props['makeDefault'])
def retCode = invokeCommand(invoke, commandArgs, isWindows, ch)
def containerSnapshotAcronym = props['containerSnapshotAcronym']
if (retCode == 0 && makeDefault && !WebSphereBPMHelper.isEmpty(containerSnapshotAcronym)) {
    def containerAcronym = props['containerAcronym']
    if (WebSphereBPMHelper.isEmpty(containerAcronym)) {
        containerAcronym = new File(".").getCanonicalFile().name //this gets resolved to component name
    }
    containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
    containerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(containerSnapshotAcronym, containerAcronym, commandArgs)

    def makeDefArgs = '[ -containerAcronym ' + containerAcronym + ' -containerSnapshotAcronym ' + containerSnapshotAcronym
    def makeDefInvoke = "AdminTask.BPMSetDefaultSnapshot('" + makeDefArgs + "]')"
    retCode = invokeCommand(makeDefInvoke, commandArgs, isWindows, ch)
}

System.exit(retCode)