/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2014, 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.websphere.bpm.WebSphereBPMHelper;

//////////////////////MAIN////////////////////////
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
final def ch = new CommandHelper(workDir)
final def props = apTool.getStepProperties()
final def isWindows = apTool.isWindows
final def compName = workDir.getCanonicalFile().name //this gets resolved to component name

def commandArgs = WebSphereBPMHelper.createCommandArgs(props, isWindows)

////////////// BPM Command Arguments /////////////
def sourceContainerSnapshotAcronym = props['sourceContainerSnapshotAcronym']
def targetContainerSnapshotAcronym = props['targetContainerSnapshotAcronym']
def containerAcronym = props['containerAcronym']

// Retrieve snapshot acronym if name is given
containerAcronym = WebSphereBPMHelper.getContainerAcronym(containerAcronym, commandArgs)
sourceContainerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(sourceContainerSnapshotAcronym, containerAcronym, commandArgs)
targetContainerSnapshotAcronym = WebSphereBPMHelper.getSnapshotTrackAcronym(targetContainerSnapshotAcronym, containerAcronym, commandArgs)

def orphanTokenPolicyFile = props['orphanTokenPolicyFile']
def useNetworkAvailablePolicyFile = props['useNetworkAvailablePolicyFile']
def orphanTokenPolicyPathString
if (orphanTokenPolicyFile) {
    if (!orphanTokenPolicyFile.endsWith(".xml")) {
        println "The Orphan Token Policy file '${orphanTokenPolicyFile}' must end with a .xml extension."
        System.exit(1)
    }
    orphanTokenPolicyPathString = WebSphereBPMHelper.getFilePath(orphanTokenPolicyFile, workDir)
    // Check if the given path exists
    if (!orphanTokenPolicyPathString) {
        println "Orphan Token Policy file '${orphanTokenPolicyFile}' was not found."
        System.exit(1)
    }
    else {
        // If file size is > 100KB (100,000 bytes), useNetworkAvailablePolicyFile must = TRUE
        File policyFile = new File(orphanTokenPolicyPathString)
        if (policyFile.length() > 100000) {
            println "Policy file ${orphanTokenPolicyFile} is ${policyFile.length()} bytes." +
                "The useNetworkAvailablePolicyFile argument must be set to true."
            useNetworkAvailablePolicyFile = "true"
        }
    }
}

//////// Construct the BPMMigrateInstances Command ////////
def containerAcronymArgs = "-containerAcronym ${containerAcronym}"
def sourceContainerSnapshotAcronymArgs = "-sourceContainerSnapshotAcronym \"${sourceContainerSnapshotAcronym}\""
def targetContainerSnapshotAcronymArgs = "-targetContainerSnapshotAcronym \"${targetContainerSnapshotAcronym}\""

def orphanTokenPolicyFileArgs = ""
if (orphanTokenPolicyFile) {
    orphanTokenPolicyFileArgs = "-orphanTokenPolicyFile \"${orphanTokenPolicyPathString}\""
}

def useNetworkAvailablePolicyFileArgs = ""
if (useNetworkAvailablePolicyFile == "false" || useNetworkAvailablePolicyFile == "true") {
    useNetworkAvailablePolicyFileArgs = "-useNetworkAvailablePolicyFile \"${useNetworkAvailablePolicyFile}\""
}

def invoke = "AdminTask.BPMMigrateInstances('[${containerAcronymArgs} ${sourceContainerSnapshotAcronymArgs} " +
            "${targetContainerSnapshotAcronymArgs} ${orphanTokenPolicyFileArgs} ${useNetworkAvailablePolicyFileArgs}]')"
def exitVal = WebSphereBPMHelper.invokeCommand(invoke, commandArgs, isWindows, ch)

System.exit(exitVal)