/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

// Sample Snapshot JSON
// {
//     "name": "Discover BPM UI Sample v8600_1",
//     "acronym": "8.6.0.0_1",
//     "active": false,
//     "createdOn": "2017-06-12T16:13:06Z",
//     "snapshotTip": true,
//     "branchID": "2063.d367c75b-45ea-4dcf-a483-547ad03d6dcb",
//     "branchName": "Main",
//     "ID": "2064.2849b2dd-b4a2-466e-9bc5-b1f7db200731"
// }

package com.urbancode.air.plugin.webspherebpm

public class Snapshot {

    private String name
    private String acronym
    private boolean active
    private String createdOn
    private boolean snapshotTip
    private String branchID
    private String branchName
    private String ID

    // UCD Version Name, but also common in WebSphere BPM
    public String getVersionName() {
        return getName() + " (" + getAcronym() + ")"
    }

    public String getName() {
        return name
    }

    public String getAcronym() {
        return acronym
    }

    public boolean getActive() {
        return active
    }

    public String getCreatedOn() {
        return createdOn
    }

    public boolean getSnapshotTip() {
        return snapshotTip
    }

    public String getBranchID() {
        return branchID
    }

    public String getBranchName() {
        return branchName
    }

    public String getID() {
        return ID
    }
}
