/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.FileListerBase;
import com.urbancode.commons.fileutils.filelister.FileListerFactory;
import com.urbancode.commons.fileutils.filelister.FileMatcher;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

final class FileListerExcludeFollow
extends FileListerBase {
    private static final Logger log = Logger.getLogger(FileListerExcludeFollow.class);
    static final FileListerFactory FACTORY = new FileListerFactory(){

        public FileListerExcludeFollow create(File base, FileMatcher matcher, PermissionReader permissionReader) throws IOException {
            return new FileListerExcludeFollow(base, matcher, permissionReader);
        }

        public String implementationName() {
            return FileListerExcludeFollow.class.getName();
        }
    };

    FileListerExcludeFollow(File base, FileMatcher matcher, PermissionReader permissionReader) throws IOException {
        super(base, matcher, permissionReader);
    }

    protected boolean includeInList(TypedFile file) {
        File translated = file.translate(this.base());
        boolean result = translated.isFile();
        LogUtil.logTrace(log, "includeInList: file=" + translated.getAbsoluteFile() + ", result=" + result);
        return result;
    }

    protected boolean isTraversable(TypedFile file) {
        File translated = file.translate(this.base());
        boolean result = translated.isDirectory();
        LogUtil.logTrace(log, "isTraversable: file=" + translated.getAbsoluteFile() + ", result=" + result);
        return result;
    }

    protected TypedFile normalize(TypedFile file) throws IOException {
        if (file.type() == FileType.SYMLINK) {
            return TypedFile.createNoSymlinks(this.base(), file.path(), this.getPermissions(file));
        }
        return file;
    }
}

