/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

package com.urbancode.air.plugin.websphere.commerce

public class WebSphereCommerceHelper {

    public static boolean isEmpty(String value) {
        return value == null || value.equals("")
    }
    
    public static String findFileByPattern(String parent, String fileToSearch) {
        File parentDir = new File(parent)
        File[] contents = parentDir.listFiles()
        def searchedFile = ""
        for (File file : contents) {
            if (file.isDirectory()) {
                if (file.getName().matches(fileToSearch)) {
                    return file.getAbsolutePath()
                } else {
                    searchedFile = findFile(file.getAbsolutePath(), fileToSearch)
                    if (! isEmpty(searchedFile)) {
                        return searchedFile
                    }
                }
            }
            else if (file.getName().matches(fileToSearch)) {
                return file.getAbsolutePath()
            }
        }
        return searchedFile
    }

    public static String findFile(String parent, String fileToSearch) {
        File parentDir = new File(parent)
        File[] contents = parentDir.listFiles()
        def searchedFile = ""
        for (File file : contents) {
            if (file.isDirectory()) {
                if (file.getName().equals(fileToSearch)) {
                    return file.getAbsolutePath()
                } else {
                    searchedFile = findFile(file.getAbsolutePath(), fileToSearch)
                    if (! isEmpty(searchedFile)) {
                        return searchedFile
                    }
                }
            }
            else if (file.getName().equals(fileToSearch)) {
                return file.getAbsolutePath()
            }
        }
        return searchedFile
    }
}
