/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphere.commerce.WebSphereCommerceHelper
import com.urbancode.commons.util.IO;

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties();

def targetEnv = props['buildLabel']
def exitVal = 0;

try {
    if (!(targetEnv =~ /(?i)\.zip$/)) {
        targetEnv = targetEnv + ".zip"
    }
    def serverPackage = WebSphereCommerceHelper.findFileByPattern(".", "(wcbd-deploy-)?" + targetEnv)
    if (!WebSphereCommerceHelper.isEmpty(serverPackage)) {
        IO.unzip(new File(serverPackage), workDir);
    } else {
        println "Server package is not present on the WebSphere Commerce machine"
        exitVal = 1;
    }
}
catch (Exception e) {
    e.printStackTrace();
    exitVal=1;
}
System.exit(exitVal);
