from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
#from ElasticityType import ElasticityType
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AppPlacementController')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAppPlacementController");
  exportedObject.put("roleName", "WebSphereAppPlacementController");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.serveroperationtimeout", objid, "serverOperationTimeOut","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.approvaltimeout", objid, "approvalTimeOut","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.mintimebetweenplacementchange", objid, "minTimeBetweenPlacementChange","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.modetimeoutunits", objid, "modeTimeOutUnits","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.consolidationmode", objid, "consolidationMode","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.enable", objid, "enable","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.enableelasticity", objid, "enableElasticity","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.modetimeout", objid, "modeTimeOut","AppPlacementController");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appplacementcontroller.mintimebetweenplacementchangeunits", objid, "minTimeBetweenPlacementChangeUnits","AppPlacementController");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AppPlacementController");

  #i = 0;
  #types = Util.parseConfigIdListAttribute(objid, 'types',"AppPlacementController");
  #for type in types:
    #if len(type) > 0:
      #returndict = Util.createTypeFolder(respath, "ElasticityType", typeFolders);
      #currespath = returndict['path'];
      #if returndict.has_key('object'):
        #Util.addFromExport(extraObjects, returndict['object']);
      #Util.addAllFromExport(extraObjects, ElasticityType._export(type, currespath, "ElasticityType%s" % i));
      #i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AppPlacementController');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('AppPlacementController')
  if not jsonobject.has("roleProperties"):
    raise Exception("AppPlacementController resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "serverOperationTimeOut", roleProperties.optString("websphere.appplacementcontroller.serveroperationtimeout", None));
  Util.addIfNotNone(properties, "approvalTimeOut", roleProperties.optString("websphere.appplacementcontroller.approvaltimeout", None));
  Util.addIfNotNone(properties, "minTimeBetweenPlacementChange", roleProperties.optString("websphere.appplacementcontroller.mintimebetweenplacementchange", None));
  Util.addIfNotNone(properties, "modeTimeOutUnits", roleProperties.optString("websphere.appplacementcontroller.modetimeoutunits", None));
  Util.addIfNotNone(properties, "consolidationMode", roleProperties.optString("websphere.appplacementcontroller.consolidationmode", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.appplacementcontroller.enable", None));
  Util.addIfNotNone(properties, "enableElasticity", roleProperties.optString("websphere.appplacementcontroller.enableelasticity", None));
  Util.addIfNotNone(properties, "modeTimeOut", roleProperties.optString("websphere.appplacementcontroller.modetimeout", None));
  Util.addIfNotNone(properties, "minTimeBetweenPlacementChangeUnits", roleProperties.optString("websphere.appplacementcontroller.mintimebetweenplacementchangeunits", None));
  print "Creating AppPlacementController with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AppPlacementController", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      projectObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      #if (propertyObject == 0):
        #if currole == "WebSphereElasticityType":
          #ElasticityType.create(objid, curjsonobject);
  Util.popPathElement('AppPlacementController');


def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('AppPlacementController')
  if not jsonobject.has("roleProperties"):
    raise Exception("AppPlacementController resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.serveroperationtimeout", None), "serverOperationTimeOut","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.approvaltimeout", None), "approvalTimeOut","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.mintimebetweenplacementchange", None), "minTimeBetweenPlacementChange","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.modetimeoutunits", None), "modeTimeOutUnits","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.consolidationmode", None), "consolidationMode","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.enable", None), "enable","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.enableelasticity", None), "enableElasticity","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.modetimeout", None), "modeTimeOut","AppPlacementController");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appplacementcontroller.mintimebetweenplacementchangeunits", None), "minTimeBetweenPlacementChangeUnits","AppPlacementController");
  if len(atts) != 0:
    print "Modifying AppPlacementController with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AppPlacementController configuration up to date.";

  Property.removeProperties(objid, 'properties',"AppPlacementController");

  types = Util.parseConfigIdListAttribute(objid, 'types',"AppPlacementController");
  for type in types:
    if len(type) > 0:
      Util.remove(type);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      projectObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      #if (propertyObject == 0):
        #if currole == "WebSphereElasticityType":
          #ElasticityType.create(objid, curjsonobject);
  Util.popPathElement('AppPlacementController');
