from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.datastoreprofile.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'DataStoreProfile');

  containmentpath = "%(parentconpath)sDataStoreProfile:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('DataStoreProfile')

  name = Util.getRequiredAttribute(objid, "name", 'DataStoreProfile');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDataStoreProfile");
  exportedObject.put("roleName", "WebSphereDataStoreProfile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.name", objid, "name","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.category", objid, "category","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.querythreshold", objid, "queryThreshold","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.maxconnectionretries", objid, "maxConnectionRetries","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.providertype", objid, "providerType","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.sqlcachesize", objid, "sqlCacheSize","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.jndiname", objid, "jndiName","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.maxpurgetransactionsize", objid, "maxPurgeTransactionSize","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.schemaname", objid, "schemaName","DataStoreProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datastoreprofile.description", objid, "description","DataStoreProfile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DataStoreProfile');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("DataStoreProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.datastoreprofile.name"):
    raise Exception("Resource role properties does not contain websphere.datastoreprofile.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create DataStoreProfile on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('DataStoreProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("DataStoreProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.datastoreprofile.name"):
    raise Exception("Resource role properties does not contain websphere.datastoreprofile.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.datastoreprofile.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.datastoreprofile.category", None));
  Util.addIfNotNone(properties, "queryThreshold", roleProperties.optString("websphere.datastoreprofile.querythreshold", None));
  Util.addIfNotNone(properties, "maxConnectionRetries", roleProperties.optString("websphere.datastoreprofile.maxconnectionretries", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.datastoreprofile.providertype", None));
  Util.addIfNotNone(properties, "sqlCacheSize", roleProperties.optString("websphere.datastoreprofile.sqlcachesize", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.datastoreprofile.jndiname", None));
  Util.addIfNotNone(properties, "maxPurgeTransactionSize", roleProperties.optString("websphere.datastoreprofile.maxpurgetransactionsize", None));
  Util.addIfNotNone(properties, "schemaName", roleProperties.optString("websphere.datastoreprofile.schemaname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.datastoreprofile.description", None));
  print "Creating DataStoreProfile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DataStoreProfile", parentid, properties);
  Util.popPathElement('DataStoreProfile');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('DataStoreProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("DataStoreProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.datastoreprofile.name"):
    raise Exception("Resource role properties does not contain websphere.datastoreprofile.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.name", None), "name","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.category", None), "category","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.querythreshold", None), "queryThreshold","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.maxconnectionretries", None), "maxConnectionRetries","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.providertype", None), "providerType","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.sqlcachesize", None), "sqlCacheSize","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.jndiname", None), "jndiName","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.maxpurgetransactionsize", None), "maxPurgeTransactionSize","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.schemaname", None), "schemaName","DataStoreProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datastoreprofile.description", None), "description","DataStoreProfile");
  if len(atts) != 0:
    print "Modifying DataStoreProfile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DataStoreProfile configuration up to date.";

  Util.popPathElement('DataStoreProfile');
