from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DistributionQueue')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDistributionQueue");
  exportedObject.put("roleName", "WebSphereDistributionQueue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.distributionqueue.queuejndiname", objid, "queueJNDIName","DistributionQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.distributionqueue.queueconnectionfactoryjndiname", objid, "queueConnectionFactoryJNDIName","DistributionQueue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DistributionQueue');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DistributionQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("DistributionQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "queueJNDIName", roleProperties.optString("websphere.distributionqueue.queuejndiname", None));
  Util.addIfNotNone(properties, "queueConnectionFactoryJNDIName", roleProperties.optString("websphere.distributionqueue.queueconnectionfactoryjndiname", None));
  print "Creating DistributionQueue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DistributionQueue", parentid, properties);
  Util.popPathElement('DistributionQueue');

def update(objid,jsonobject):
  Util.pushPathElement('DistributionQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("DistributionQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.distributionqueue.queuejndiname", None), "queueJNDIName","DistributionQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.distributionqueue.queueconnectionfactoryjndiname", None), "queueConnectionFactoryJNDIName","DistributionQueue");
  if len(atts) != 0:
    print "Modifying DistributionQueue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DistributionQueue configuration up to date.";

  Util.popPathElement('DistributionQueue');
