from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EXtremeScaleDomains')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEXtremeScaleDomains");
  exportedObject.put("roleName", "WebSphereEXtremeScaleDomains");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extremescaledomains.name", objid, "name","EXtremeScaleDomains");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extremescaledomains.default", objid, "default","EXtremeScaleDomains");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"EXtremeScaleDomains");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EXtremeScaleDomains');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EXtremeScaleDomains')
  if not jsonobject.has("roleProperties"):
    raise Exception("EXtremeScaleDomains resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.extremescaledomains.name", None));
  Util.addIfNotNone(properties, "default", roleProperties.optString("websphere.extremescaledomains.default", None));
  print "Creating EXtremeScaleDomains with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EXtremeScaleDomains", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EXtremeScaleDomains');

def update(objid,jsonobject):
  Util.pushPathElement('EXtremeScaleDomains')
  if not jsonobject.has("roleProperties"):
    raise Exception("EXtremeScaleDomains resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extremescaledomains.name", None), "name","EXtremeScaleDomains");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extremescaledomains.default", None), "default","EXtremeScaleDomains");
  if len(atts) != 0:
    print "Modifying EXtremeScaleDomains with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EXtremeScaleDomains configuration up to date.";

  Property.removeProperties(objid, 'properties',"EXtremeScaleDomains");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EXtremeScaleDomains');
