from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthForeignBus')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthForeignBus");
  exportedObject.put("roleName", "WebSphereSIBAuthForeignBus");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthforeignbus.busname", objid, "busName","SIBAuthForeignBus");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthForeignBus');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthForeignBus')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignBus resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibauthforeignbus.busname", None));
  print "Creating SIBAuthForeignBus with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthForeignBus", parentid, properties);
  Util.popPathElement('SIBAuthForeignBus');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthForeignBus')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignBus resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthforeignbus.busname", None), "busName","SIBAuthForeignBus");
  if len(atts) != 0:
    print "Modifying SIBAuthForeignBus with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthForeignBus configuration up to date.";

  Util.popPathElement('SIBAuthForeignBus');
