from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthGroup')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthGroup");
  exportedObject.put("roleName", "WebSphereSIBAuthGroup");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthgroup.uniquename", objid, "uniqueName","SIBAuthGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthgroup.identifier", objid, "identifier","SIBAuthGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthGroup');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uniqueName", roleProperties.optString("websphere.sibauthgroup.uniquename", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthgroup.identifier", None));
  print "Creating SIBAuthGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthGroup", parentid, properties);
  Util.popPathElement('SIBAuthGroup');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthgroup.uniquename", None), "uniqueName","SIBAuthGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthgroup.identifier", None), "identifier","SIBAuthGroup");
  if len(atts) != 0:
    print "Modifying SIBAuthGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthGroup configuration up to date.";

  Util.popPathElement('SIBAuthGroup');
