from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthWebService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthWebService");
  exportedObject.put("roleName", "WebSphereSIBAuthWebService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthwebservice.inheritdefaults", objid, "inheritDefaults","SIBAuthWebService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthwebservice.identifier", objid, "identifier","SIBAuthWebService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthWebService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthWebService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthWebService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritDefaults", roleProperties.optString("websphere.sibauthwebservice.inheritdefaults", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthwebservice.identifier", None));
  print "Creating SIBAuthWebService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthWebService", parentid, properties);
  Util.popPathElement('SIBAuthWebService');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthWebService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthWebService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthwebservice.inheritdefaults", None), "inheritDefaults","SIBAuthWebService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthwebservice.identifier", None), "identifier","SIBAuthWebService");
  if len(atts) != 0:
    print "Modifying SIBAuthWebService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthWebService configuration up to date.";

  Util.popPathElement('SIBAuthWebService');
