from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBDestinationMediationRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBDestinationMediationRef");
  exportedObject.put("roleName", "WebSphereSIBDestinationMediationRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediationref.enabled", objid, "enabled","SIBDestinationMediationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediationref.externallymediated", objid, "externallyMediated","SIBDestinationMediationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediationref.uuid", objid, "uuid","SIBDestinationMediationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationmediationref.mediationuuid", objid, "mediationUuid","SIBDestinationMediationRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBDestinationMediationRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBDestinationMediationRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationMediationRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.sibdestinationmediationref.enabled", None));
  Util.addIfNotNone(properties, "externallyMediated", roleProperties.optString("websphere.sibdestinationmediationref.externallymediated", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibdestinationmediationref.uuid", None));
  Util.addIfNotNone(properties, "mediationUuid", roleProperties.optString("websphere.sibdestinationmediationref.mediationuuid", None));
  print "Creating SIBDestinationMediationRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBDestinationMediationRef", parentid, properties);
  Util.popPathElement('SIBDestinationMediationRef');

def update(objid,jsonobject):
  Util.pushPathElement('SIBDestinationMediationRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationMediationRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediationref.enabled", None), "enabled","SIBDestinationMediationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediationref.externallymediated", None), "externallyMediated","SIBDestinationMediationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediationref.uuid", None), "uuid","SIBDestinationMediationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationmediationref.mediationuuid", None), "mediationUuid","SIBDestinationMediationRef");
  if len(atts) != 0:
    print "Modifying SIBDestinationMediationRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBDestinationMediationRef configuration up to date.";

  Util.popPathElement('SIBDestinationMediationRef');
