from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ManagementScopeRef import ManagementScopeRef
from SSLConfigRef import SSLConfigRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SSLConfigGroup')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSSLConfigGroup");
  exportedObject.put("roleName", "WebSphereSSLConfigGroup");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sslconfiggroup.name", objid, "name","SSLConfigGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sslconfiggroup.direction", objid, "direction","SSLConfigGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sslconfiggroup.certificatealias", objid, "certificateAlias","SSLConfigGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'SSLConfigGroup');
  if managementScope is not None and len(managementScope) > 0:
    returndict = Util.createTypeFolder(respath, "ManagementScopeRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ManagementScopeRef._export(managementScope, currespath, "ManagementScope"));

  sslConfig = Util.getOptionalAttribute(objid, 'sslConfig', 'SSLConfigGroup');
  if sslConfig is not None and len(sslConfig) > 0:
    returndict = Util.createTypeFolder(respath, "SSLConfigRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SSLConfigRef._export(sslConfig, currespath, "SSLConfig"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SSLConfigGroup');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SSLConfigGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLConfigGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sslconfiggroup.name", None));
  Util.addIfNotNone(properties, "direction", roleProperties.optString("websphere.sslconfiggroup.direction", None));
  Util.addIfNotNone(properties, "certificateAlias", roleProperties.optString("websphere.sslconfiggroup.certificatealias", None));
  print "Creating SSLConfigGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SSLConfigGroup", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereManagementScopeRef":
        ManagementScopeRef.create(objid, curjsonobject, "managementScope");
      elif currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "sslConfig");
  Util.popPathElement('SSLConfigGroup');

def update(objid,jsonobject):
  Util.pushPathElement('SSLConfigGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLConfigGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sslconfiggroup.name", None), "name","SSLConfigGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sslconfiggroup.direction", None), "direction","SSLConfigGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sslconfiggroup.certificatealias", None), "certificateAlias","SSLConfigGroup");
  if len(atts) != 0:
    print "Modifying SSLConfigGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SSLConfigGroup configuration up to date.";

  Util.unsetAttribute(objid, "managementScope", "SSLConfigGroup");
  Util.unsetAttribute(objid, "sslConfig", "SSLConfigGroup");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereManagementScopeRef":
        ManagementScopeRef.create(objid, curjsonobject, "managementScope");
      elif currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "sslConfig");
  Util.popPathElement('SSLConfigGroup');
