#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from TAInterceptor import TAInterceptor

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TrustAssociation')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTrustAssociation");
  exportedObject.put("roleName", "WebSphereTrustAssociation");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustassociation.enabled", objid, "enabled","TrustAssociation");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  interceptors = Util.parseConfigIdListAttribute(objid, 'interceptors', 'TrustAssociation');
  #Sorting is needed in an attempt to keep the same order for the Interceptors when doing a resource tree compare.
  interceptors.sort();
  for interceptor in interceptors:
    if len(interceptor) > 0:
      returndict = Util.createTypeFolder(respath, "TAInterceptor", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, TAInterceptor._export(interceptor, currespath, "TAInterceptor%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TrustAssociation');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TrustAssociation')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustAssociation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.trustassociation.enabled", None));
  print "Creating TrustAssociation with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TrustAssociation", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereTAInterceptor":
        TAInterceptor.create(objid, curjsonobject);
  Util.popPathElement('TrustAssociation');

def update(objid,jsonobject):
  Util.pushPathElement('TrustAssociation')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustAssociation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustassociation.enabled", None), "enabled","TrustAssociation");
  if len(atts) != 0:
    print "Modifying TrustAssociation with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TrustAssociation configuration up to date.";

  interceptors = Util.parseConfigIdListAttribute(objid, 'interceptors', 'TrustAssociation');
  for interceptor in interceptors:
    if len(interceptor) > 0:
      Util.remove(interceptor);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereTAInterceptor":
        TAInterceptor.create(objid, curjsonobject);
  Util.popPathElement('TrustAssociation');
