from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.workmanagerinfo.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'WorkManagerInfo');

  containmentpath = "%(parentconpath)sWorkManagerInfo:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('WorkManagerInfo')

  name = Util.getRequiredAttribute(objid, "name", 'WorkManagerInfo');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkManagerInfo");
  exportedObject.put("roleName", "WebSphereWorkManagerInfo");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.isdistributable", objid, "isDistributable","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.daemontranclass", objid, "daemonTranClass","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.providertype", objid, "providerType","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.threadpriority", objid, "threadPriority","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.workreqqsize", objid, "workReqQSize","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.minthreads", objid, "minThreads","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.jndiname", objid, "jndiName","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.maxthreads", objid, "maxThreads","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.isgrowable", objid, "isGrowable","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.category", objid, "category","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.description", objid, "description","WorkManagerInfo");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.workmanagerinfo.servicenames", objid, "serviceNames","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.deftranclass", objid, "defTranClass","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.worktimeout", objid, "workTimeout","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.numalarmthreads", objid, "numAlarmThreads","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.workreqqfullaction", objid, "workReqQFullAction","WorkManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerinfo.name", objid, "name","WorkManagerInfo");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkManagerInfo');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.workmanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.workmanagerinfo.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create WorkManagerInfo on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('WorkManagerInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workmanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.workmanagerinfo.name!");

  properties = [];
  Util.addIfNotNone(properties, "isDistributable", roleProperties.optString("websphere.workmanagerinfo.isdistributable", None));
  Util.addIfNotNone(properties, "daemonTranClass", roleProperties.optString("websphere.workmanagerinfo.daemontranclass", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.workmanagerinfo.providertype", None));
  Util.addIfNotNone(properties, "threadPriority", roleProperties.optString("websphere.workmanagerinfo.threadpriority", None));
  Util.addIfNotNone(properties, "workReqQSize", roleProperties.optString("websphere.workmanagerinfo.workreqqsize", None));
  Util.addIfNotNone(properties, "minThreads", roleProperties.optString("websphere.workmanagerinfo.minthreads", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.workmanagerinfo.jndiname", None));
  Util.addIfNotNone(properties, "maxThreads", roleProperties.optString("websphere.workmanagerinfo.maxthreads", None));
  Util.addIfNotNone(properties, "isGrowable", roleProperties.optString("websphere.workmanagerinfo.isgrowable", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.workmanagerinfo.category", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.workmanagerinfo.description", None));
  Util.addPathProperty(properties, "serviceNames", roleProperties.optString("websphere.workmanagerinfo.servicenames", None));
  Util.addIfNotNone(properties, "defTranClass", roleProperties.optString("websphere.workmanagerinfo.deftranclass", None));
  Util.addIfNotNone(properties, "workTimeout", roleProperties.optString("websphere.workmanagerinfo.worktimeout", None));
  Util.addIfNotNone(properties, "numAlarmThreads", roleProperties.optString("websphere.workmanagerinfo.numalarmthreads", None));
  Util.addIfNotNone(properties, "workReqQFullAction", roleProperties.optString("websphere.workmanagerinfo.workreqqfullaction", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.workmanagerinfo.name", None));
  print "Creating WorkManagerInfo with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkManagerInfo", parentid, properties);
  Util.popPathElement('WorkManagerInfo');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('WorkManagerInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workmanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.workmanagerinfo.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.isdistributable", None), "isDistributable","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.daemontranclass", None), "daemonTranClass","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.providertype", None), "providerType","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.threadpriority", None), "threadPriority","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.workreqqsize", None), "workReqQSize","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.minthreads", None), "minThreads","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.jndiname", None), "jndiName","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.maxthreads", None), "maxThreads","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.isgrowable", None), "isGrowable","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.category", None), "category","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.description", None), "description","WorkManagerInfo");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.servicenames", None), "serviceNames","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.deftranclass", None), "defTranClass","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.worktimeout", None), "workTimeout","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.numalarmthreads", None), "numAlarmThreads","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.workreqqfullaction", None), "workReqQFullAction","WorkManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerinfo.name", None), "name","WorkManagerInfo");
  if len(atts) != 0:
    print "Modifying WorkManagerInfo with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkManagerInfo configuration up to date.";

  Util.popPathElement('WorkManagerInfo');
