from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ConfigProperty')

  attrname = Util.getOptionalAttribute(objid, "name", 'ConfigProperty');
  if attrname is not None and len(attrname) > 0:
    name = attrname;

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConfigProperty");
  exportedObject.put("roleName", "WebSphereConfigProperty");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configproperty.name", objid, "name","ConfigProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configproperty.type", objid, "type","ConfigProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configproperty.description", objid, "description","ConfigProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configproperty.confidential", objid, "confidential","ConfigProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configproperty.value", objid, "value","ConfigProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configproperty.supportsdynamicupdates", objid, "supportsDynamicUpdates","ConfigProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.configproperty.ignore", objid, "ignore","ConfigProperty");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ConfigProperty');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ConfigProperty');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ConfigProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConfigProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.configproperty.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.configproperty.type", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.configproperty.description", None));
  Util.addIfNotNone(properties, "confidential", roleProperties.optString("websphere.configproperty.confidential", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.configproperty.value", None));
  Util.addIfNotNone(properties, "supportsDynamicUpdates", roleProperties.optString("websphere.configproperty.supportsdynamicupdates", None));
  Util.addIfNotNone(properties, "ignore", roleProperties.optString("websphere.configproperty.ignore", None));
  print "Creating ConfigProperty with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ConfigProperty", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('ConfigProperty');

def update(objid,jsonobject):
  Util.pushPathElement('ConfigProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConfigProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configproperty.name", None), "name","ConfigProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configproperty.type", None), "type","ConfigProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configproperty.description", None), "description","ConfigProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configproperty.confidential", None), "confidential","ConfigProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configproperty.value", None), "value","ConfigProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configproperty.supportsdynamicupdates", None), "supportsDynamicUpdates","ConfigProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.configproperty.ignore", None), "ignore","ConfigProperty");
  if len(atts) != 0:
    print "Modifying ConfigProperty with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ConfigProperty configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ConfigProperty');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('ConfigProperty');
