from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Cookie')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCookie");
  exportedObject.put("roleName", "WebSphereCookie");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cookie.maximumage", objid, "maximumAge","Cookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cookie.name", objid, "name","Cookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cookie.usecontextrootaspath", objid, "useContextRootAsPath","Cookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cookie.domain", objid, "domain","Cookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cookie.secure", objid, "secure","Cookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cookie.path", objid, "path","Cookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cookie.httponly", objid, "httpOnly","Cookie");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Cookie');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Cookie')
  if not jsonobject.has("roleProperties"):
    raise Exception("Cookie resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maximumAge", roleProperties.optString("websphere.cookie.maximumage", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.cookie.name", None));
  Util.addIfNotNone(properties, "useContextRootAsPath", roleProperties.optString("websphere.cookie.usecontextrootaspath", None));
  Util.addIfNotNone(properties, "domain", roleProperties.optString("websphere.cookie.domain", None));
  Util.addIfNotNone(properties, "secure", roleProperties.optString("websphere.cookie.secure", None));
  Util.addIfNotNone(properties, "path", roleProperties.optString("websphere.cookie.path", None));
  Util.addIfNotNone(properties, "httpOnly", roleProperties.optString("websphere.cookie.httponly", None));
  print "Creating Cookie with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Cookie", parentid, properties);
  Util.popPathElement('Cookie');

def update(objid,jsonobject):
  Util.pushPathElement('Cookie')
  if not jsonobject.has("roleProperties"):
    raise Exception("Cookie resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cookie.maximumage", None), "maximumAge","Cookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cookie.name", None), "name","Cookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cookie.usecontextrootaspath", None), "useContextRootAsPath","Cookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cookie.domain", None), "domain","Cookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cookie.secure", None), "secure","Cookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cookie.path", None), "path","Cookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cookie.httponly", None), "httpOnly","Cookie");
  if len(atts) != 0:
    print "Modifying Cookie with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Cookie configuration up to date.";

  Util.popPathElement('Cookie');
