from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DeploymentTargetMapping import DeploymentTargetMapping
from Property import Property
from Classloader import Classloader

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EJBModuleDeployment')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEJBModuleDeployment");
  exportedObject.put("roleName", "WebSphereEJBModuleDeployment");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduledeployment.name", objid, "name","EJBModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduledeployment.startingweight", objid, "startingWeight","EJBModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduledeployment.uri", objid, "uri","EJBModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduledeployment.deploymentid", objid, "deploymentId","EJBModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbmoduledeployment.altdd", objid, "altDD","EJBModuleDeployment");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"EJBModuleDeployment");
  i = 0;
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"EJBModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      returndict = Util.createTypeFolder(respath, "DeploymentTargetMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DeploymentTargetMapping._export(targetmapping, currespath, "DeploymentTargetMapping%s" % i));
      i = i + 1;
      
  classloader = Util.getRequiredAttribute(objid, 'classloader',"EJBModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    returndict = Util.createTypeFolder(respath, "Classloader", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, Classloader._export(classloader, currespath, "Classloader"));      
    
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EJBModuleDeployment');
  return result;

def create(parentid, jsonobject):
  Util.pushPathElement('EJBModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.ejbmoduledeployment.name", None));
  Util.addIfNotNone(properties, "startingWeight", roleProperties.optString("websphere.ejbmoduledeployment.startingweight", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.ejbmoduledeployment.uri", None));
  Util.addIfNotNone(properties, "deploymentId", roleProperties.optString("websphere.ejbmoduledeployment.deploymentid", None));
  Util.addIfNotNone(properties, "altDD", roleProperties.optString("websphere.ejbmoduledeployment.altdd", None));
  print "Creating EJBModuleDeployment with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EJBModuleDeployment", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EJBModuleDeployment');
 
def update(objid,jsonobject):
  Util.pushPathElement('EJBModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduledeployment.name", None), "name","EJBModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduledeployment.startingweight", None), "startingWeight","EJBModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduledeployment.uri", None), "uri","EJBModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduledeployment.deploymentid", None), "deploymentId","EJBModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbmoduledeployment.altdd", None), "altDD","EJBModuleDeployment");
  if len(atts) != 0:
    print "Modifying EJBModuleDeployment with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EJBModuleDeployment configuration up to date.";

  Property.removeProperties(objid, 'properties',"EJBModuleDeployment");
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"EJBModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      Util.remove(targetmapping);

  classloader = Util.getRequiredAttribute(objid, 'classloader',"EJBModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    Util.remove(classloader);        
      
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EJBModuleDeployment');
